--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Plant.Rule_Buffer.Writing;

with Nomo.Interpreter.External_Messages;

with Nomo.Interpreter.Plant.Errors_Manager;

with Nomo.Interpreter.Plant.Targets;

with Nomo.Interpreter.Plant.Operators;

with Nomo.Interpreter.Plant.Affectation_Manager;

with Nomo.Interpreter.Plant.External_Pointer;

with Nomo.Interpreter.Types_Directory.Relations;

with Nomo.Interpreter.Event_Memory.External.Plant;

package body Nomo.Interpreter.Plant.External_Chunk is

   use Targets;

   Hit        : Target;
   Operation  : Positive;
   Data       : External_Messages.External_Message;
   Is_Present : Boolean := False;

   procedure Assume (T : in Positive_Time) is
      use Errors_Manager;
      use Types_Directory.Relations;
   begin
      if Is_Present then
         if External_Pointer.Is_Expired (T) then
            Error (EXPIRED_EXTERNAL_CHUNCK);
         else
            External_Pointer.Get_Target (Hit);
            Event_Memory.External.Plant.Get_Event (Hit.Index,
                                                   External_Pointer.Get_Event_Position,
                                                   Data,
                                                   Types_Directory.Relations.Get_Data_Size (Hit.Index));
            Is_Present := False;
         end if;
      end if;
   end Assume;

   procedure Assume_With_Target (Target_Capture_Time : in Positive_Time;
                                 Target_Arrival_Time : in Positive_Time) is
      use Errors_Manager;
      use Types_Directory.Relations;
   begin
      pragma Assert (Is_Present);
      External_Pointer.Get_Target(Hit);
      Hit.Arrival_Time := Target_Arrival_Time;
      Hit.Capture_Time := Target_Capture_Time;
      Event_Memory.External.Plant.Get_Event (Hit.Index,
                                             Hit.Arrival_Time,
                                             Data,
                                             Get_Data_Size (Hit.Index));
      if Hit.Arrival_Time = 0 then
         Error (FAIL_TARGETED_AFFECTATION);
      end if;
      Is_Present := False;
   end Assume_With_Target;

   procedure Cancel is
   begin
      Is_Present := False;
   end Cancel;

   function Is_Active return Boolean is
   begin
      return Is_Present;
   end Is_Active;

   function Is_Expired (T : in Positive_Time) return Boolean is
   begin
      return Hit.Is_Expired (T);
   end Is_Expired;

   function Get_Arrival_Time return Positive_Time is
   begin
      return Hit.Arrival_Time;
   end Get_Arrival_Time;

   function Get_Type_Index return External_Type_Index is
   begin
      return Hit.Index;
   end Get_Type_Index;

   procedure Registry is
      use Errors_Manager;
      use Operators;
   begin
      if Is_Present then
         if Operation <= Operator_Without_Parameter'Pos (Operator_Without_Parameter'Last) then
            Affectation_Manager.Set_External_Operation (Operation);
         else
            Error (ILLEGAL_OPERATOR_IN_AFFECTATION);
         end if;
      end if;
   end Registry;

   procedure Send_In_Excitatory_Condition is
      use Errors_Manager;
   begin
      if Is_Present then
         if Operation in Operators.External_Operators_With_Parameters'Range then
            Rule_Buffer.Writing.Set_External_Condition (Hit.Index,
                                                        Data,
                                                        Hit.Arrival_Time,
                                                        Operation);
            Is_Present := False;
         else
            Error (ILLEGAL_OPERATOR_IN_CONDITION);
         end if;
      end if;
   end Send_In_Excitatory_Condition;

   function Get_Operator return Positive is
   begin
      return Operation;
   end Get_Operator;

   procedure Set_Operation (Information : in Positive_Integer) is
   begin
      Operation := Positive (Information);
      Is_Present := True;
   end Set_Operation;

   procedure Set_Temporal_Reference (Is_Reference_And_Origin : in Boolean) is
   begin
      if Is_Reference_And_Origin then
         Rule_Buffer.Writing.Set_Temporal_Reference (Hit.Arrival_Time);
      else
         Rule_Buffer.Writing.Set_Temporal_Reference (Hit.Capture_Time);
      end if;
   end Set_Temporal_Reference;

end Nomo.Interpreter.Plant.External_Chunk;
