--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

limited with Nomo.Interpreter.Storages;

with Nomo.Interpreter.Types_Index.Ranges;

with Nomo.Interpreter.Perception_Rules;

with Nomo.Numerics.Informations;

package Nomo.Interpreter.Perceptions_Clusters.Loading is

   use Types_Index.Ranges;
   use Perception_Rules;
   use Numerics.Informations;

   function Get_Perception (This        : in Perceptions_Cluster;
                            Information : in Positive_Integer) return access Perception_Rule;
   pragma Inline(Get_Perception);

   function Has_Space (This : in Perceptions_Cluster) return Boolean;

   procedure Initialize (This            : in out Perceptions_Cluster;
                         Perception_Type : in Perception_Type_Index);

   procedure Load (This             : in out Perceptions_Cluster;
                   Rule_Storage_Ptr : not null access constant Storages.Full_Rule_Storage);
   pragma Inline (Load);

end Nomo.Interpreter.Perceptions_Clusters.Loading;
