--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Informations;
use Nomo.Numerics.Informations;

generic
   with function Get_Conclusion_Information (This : in Rule) return Positive_Integer;
   type Linked_Cluster is limited private;
   type Links is limited private;
   with function Get_Link (This        : in Linked_Cluster;
                           Information : in Positive_Integer) return access Links;
   with procedure Set_Linked_Rule (This : out Rule;
                                   Link : access Links);
package Nomo.Interpreter.Gen_Rules_Directories.Linking is

   pragma Pure;

   procedure Initialize_Links (This   : in Rules_Directory;
                               Target : in Linked_Cluster);

end Nomo.Interpreter.Gen_Rules_Directories.Linking;
