--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package body Nomo.Interpreter.Gen_Rules_Directories.Initialization is

   procedure Initialize (This      : in out Rules_Directory;
                         I         : in Positive;
                         Reference : not null Rule_Ptr) is
   begin
      pragma Assert (This.References (Reference_Index (I)).Reference = null);
      pragma Assert (I = 1 or else This.References(Reference_Index (I-1)).Reference /= null);
      This.References (Reference_Index (I)).Reference := Reference;
   end Initialize;

end Nomo.Interpreter.Gen_Rules_Directories.Initialization;
