--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

generic
   with procedure Evaluate (This : in out Rule);
   with function Is_Forget (This : in Rule) return Boolean;
   with function Is_Ongoing (This : in Rule) return Boolean;
   with function Is_Updatable (This : in Rule) return Boolean;
   with procedure Update_Relevance (This : in out Rule);
package Nomo.Interpreter.Gen_Rules_Directories.Checking is

   pragma Pure;

   type Checking_Directory is new Rules_Directory with private;

   procedure Select_And_Update (This        : in out Checking_Directory;
                                Rule_Tested : out Rule_Ptr);

   procedure Update_Relevance (This : in out Checking_Directory);

   procedure Reset_Tested_Reference (This : in out Checking_Directory);

private

   type Checking_Directory is new Rules_Directory with record
      Tested_Reference_Index : Reference_Index_Minus := Reference_Index_Minus'First;
   end record;

end Nomo.Interpreter.Gen_Rules_Directories.Checking;
