--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Logger;

package body Nomo.Interpreter.Gen_Clusters_Base.Logging is

   procedure Log (This       : in Cluster;
                  Buffer_Ptr : not null access Storages.Full_Rule_Storage;
                  Flag       : in Log_Flag) is
      use Logging_Instance;
   begin
      case Flag is
         when Winner_Partial =>
            if Cluster_Base (This).Selected_Rule /= null then
               Log_Partial (Cluster_Base (This).Selected_Rule.all, Buffer_Ptr);
               Logger.Log_Partial (Buffer_Ptr);
            end if;
         when Winner_Full =>
            if Cluster_Base (This).Selected_Rule /= null then
               Log_Full (Cluster_Base (This).Selected_Rule.all, Buffer_Ptr);
               Logger.Log_Full (Buffer_Ptr);
            end if;
         when All_Rule_Partial =>
            Log_Partial (Rules_Directory (Cluster_Base (This).Directory), Buffer_Ptr);
         when All_Rule_Full =>
            Log_Full (Rules_Directory (Cluster_Base (This).Directory), Buffer_Ptr);
         when others =>
            null;
      end case;
   end Log;

end Nomo.Interpreter.Gen_Clusters_Base.Logging;
