--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Epistemic_Memory.Conceptive;

with Nomo.Interpreter.Epistemic_Memory.Landmarking;

with Nomo.Interpreter.Epistemic_Memory.Commanding;

with Nomo.Interpreter.Epistemic_Memory.Perceptive;

with Nomo.Interpreter.Epistemic_Memory.Predictive;

with Nomo.Interpreter.Epistemic_Memory.Reflective;

package body Nomo.Interpreter.Epistemic_Memory.Reinforcement is

   procedure Reinforce (I               : in Internal_Type_Index;
                        T               : in Positive_Time;
                        First_Landmark  : in Positive_Time_Interval;
                        Second_Landmark : in Positive_Time_Interval;
                        Quantity        : in Real_Accurately_0_To_1) is
   begin
      if I in Conception_Type_Index'Range then
         Epistemic_Memory.Conceptive.Reinforce (I, T, First_Landmark, Second_Landmark, Quantity);
      elsif I in Landmark_Type_Index'Range then
         Epistemic_Memory.Landmarking.Reinforce (I, T, First_Landmark, Second_Landmark, Quantity);
      elsif I in Command_Type_Index'Range then
         Epistemic_Memory.Commanding.Reinforce (I, T, First_Landmark, Second_Landmark, Quantity);
      elsif I in Perception_Type_Index'Range then
         Epistemic_Memory.Perceptive.Reinforce (I, T, First_Landmark, Second_Landmark, Quantity);
      elsif I in Prediction_Type_Index'Range then
         Epistemic_Memory.Predictive.Reinforce (I, T, First_Landmark, Second_Landmark, Quantity);
      else
         Epistemic_Memory.Reflective.Reinforce (I, T, First_Landmark, Second_Landmark, Quantity);
      end if;
   end Reinforce;

end Nomo.Interpreter.Epistemic_Memory.Reinforcement;
