--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Logger;
pragma Elaborate_All (Nomo.Interpreter.Logger);

with Nomo.Interpreter.Epistemic_Memory.Checking.Logging;

with Nomo.Interpreter.Epistemic_Memory.Conceptive.Logging;

with Nomo.Interpreter.Epistemic_Memory.Landmarking.Logging;

with Nomo.Interpreter.Epistemic_Memory.Commanding.Logging;

with Nomo.Interpreter.Epistemic_Memory.Perceptive.Logging;

with Nomo.Interpreter.Epistemic_Memory.Predictive.Logging;

with Nomo.Interpreter.Epistemic_Memory.Reflective.Logging;

with Nomo.Interpreter.Epistemic_Memory.Rewarding.Logging;

package body Nomo.Interpreter.Epistemic_Memory.Logging is

   procedure Log (T       : in Time;
                  Context : in File_Flag) is
   begin
      Logger.Set_Time (T, Context);
      Epistemic_Memory.Checking.Logging.Log;
      Epistemic_Memory.Conceptive.Logging.Log;
      Epistemic_Memory.Landmarking.Logging.Log;
      Epistemic_Memory.Commanding.Logging.Log;
      Epistemic_Memory.Perceptive.Logging.Log;
      Epistemic_Memory.Predictive.Logging.Log;
      Epistemic_Memory.Reflective.Logging.Log;
      Epistemic_Memory.Rewarding.Logging.Log;
   end Log;

end Nomo.Interpreter.Epistemic_Memory.Logging;
