--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Times;

with Nomo.Interpreter.Premises_Index;

with Nomo.Interpreter.Actuators_Buffers;

package Nomo.Interpreter.Conditions_Base.Checking is

   use Actuators_Buffers;
   use Premises_Index.Premises_Index_Instance;
   use Numerics.Times;

   procedure Maximize (This       : in out Condition_Base;
                       Candidates : in Actuators_Buffer;
                       Landmark   : in Premise_Index;
                       Time_Span  : out Positive_Time_Interval;
                       Bonus      : out Positive_Time_Interval);
   pragma Precondition (Landmark > 0);
   pragma Inline (Maximize);

   procedure Note (This       : in Condition_Base;
                   Candidates : out Actuators_Buffer);
   pragma Inline (Note);

end Nomo.Interpreter.Conditions_Base.Checking;
