--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Times;

with Nomo.Numerics.Accurately;

private with Nomo.Interpreter.Beginning.Parameters;
pragma Elaborate_All (Nomo.Interpreter.Beginning.Parameters);

private with Nomo.Interpreter.Gen_Rules_Directories.Checking;
pragma Elaborate_All (Nomo.Interpreter.Gen_Rules_Directories.Checking);

private with Nomo.Interpreter.Check_Rules;

private with Nomo.Interpreter.Internal_Events_Index.Matchmakers;

private with Nomo.Interpreter.Types_Index.Ranges;

private package Nomo.Interpreter.Checks_Clusters is

   type Checks_Cluster is tagged limited private;

   use Numerics.Times;

   procedure Assume (This : in out Checks_Cluster;
                     T    : in Positive_Time);

   function Has_Selection (This : in Checks_Cluster) return Boolean;
   pragma Inline (Has_Selection);

   procedure Interpret (This : in out Checks_Cluster);

   use Numerics.Accurately;

   procedure Reinforce (This            : in out Checks_Cluster;
                        T               : in Positive_Time;
                        First_Landmark  : in Positive_Time_Interval;
                        Second_Landmark : in Positive_Time_Interval;
                        Quantity        : in Real_Accurately_0_To_1) is null;

private

   use Types_Index.Ranges;
   use Check_Rules;

   type Check_Rule_Ptr is access all Check_Rule;

   package Local_Rules_Directories is new Gen_Rules_Directories (Check_Rule,
                                                             Check_Rule_Ptr,
                                                             Beginning.Parameters.Get_Maximum_Of_Rules_By_Type);
   use Local_Rules_Directories;

   package Local_Checking_Directories is new Local_Rules_Directories.Checking (Evaluate,
                                                                               Is_Forget,
                                                                               Is_Ongoing,
                                                                               Is_Updatable,
                                                                               Update_Relevance);
   use Local_Checking_Directories;

   type Rule_Index is new Positive range 1 .. Beginning.Parameters.Get_Maximum_Of_Rules_By_Type;

   type Rules_Store is array (Rule_Index'Range) of aliased Check_Rule;

   type Checks_Cluster is tagged limited record
      Matchmaker        : aliased Internal_Events_Index.Matchmakers.Matchmaker;
      Directory         : Checking_Directory;
      Store             : aliased Rules_Store;
      Check_Type        : Check_Type_Index;
      Prediction_Type   : Prediction_Type_Index;
      Selected_Rule     : Check_Rule_Ptr := null;
      Tested_Rule       : Check_Rule_Ptr := null;
      Last_Loaded       : Check_Rule_Ptr := null;
   end record;

end Nomo.Interpreter.Checks_Clusters;
