--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package body Nomo.Internal_Messages.Plant is

   function Get_Information (This : in Internal_Message) return Positive_Integer is
   begin
      return This.Information;
   end Get_Information;

   procedure Set_Information (This        : in out Internal_Message;
                              Information : in Positive_Integer) is
   begin
      This.Information := Information;
   end Set_Information;


   function Get_Credibility  (This : in Internal_Message) return Real_0_To_1 is
   begin
      return This.Credibility;
   end Get_Credibility;

   procedure Set_Credibility (This        : in out Internal_Message;
                              Credibility : in Real_0_To_1) is
   begin
      This.Credibility := Credibility;
   end Set_Credibility;

   procedure Set_Time_Span (This     : in out Internal_Message;
                            Time_Span : in Time_Interval) is
   begin
      This.Time_Span := Time_Span;
   end Set_Time_Span;

   procedure Copy (This   : out Internal_Message;
                   Source : in Internal_Message) is
   begin
      This.Information := Source.Information;
      This.Credibility := Source.Credibility;
   end Copy;

end Nomo.Internal_Messages.Plant;
