--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package body Nomo.Gen_Time_Log_Header.Reading is

   Is_Initialized : Boolean := False;

   procedure Initialize (Stream : in not null Ada.Streams.Stream_IO.Stream_Access) is
   begin
      pragma Assert (not Is_Initialized);
      Natural'Read (Stream, Premises_Maximum);
      Natural'Read (Stream, Components_Maximum);
      for I in Dictionary'Range loop
         Type_Category'Read (Stream, Dictionary (I));
      end loop;
      Is_Initialized := True;
   end Initialize;

   function Get_Category (I : in Internal_Type_Index) return Type_Category is
   begin
      pragma Assert (Is_Initialized);
      return Dictionary (I);
   end Get_Category;

   function Get_Maximum_Of_Premises return Natural is
   begin
      pragma Assert (Is_Initialized);
      return Premises_Maximum;
   end Get_Maximum_Of_Premises;

   function Get_Maximum_Of_Components return Natural is
   begin
      pragma Assert (Is_Initialized);
      return Components_Maximum;
   end Get_Maximum_Of_Components;

end Nomo.Gen_Time_Log_Header.Reading;
