--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Accurately;

with Nomo.Numerics.Fitting;

with Nomo.Numerics.Reals;

with Nomo.Internal_Messages.Conclusions;

private generic
   type Premise_Index is (<>);
   type Internal_Type_Index is (<>);
   type External_Type_Index is (<>);
   type Component_Index is (<>);
   type Internal_Premises is limited private;
   type Internal_Premises_Types is limited private;
   type Internal_Premises_Properties is limited private;
   type External_Message is limited private;
   type External_Premise is limited private;
package Nomo.Gen_Rule_Storages is

   pragma Pure;

   use Numerics.Accurately;
   use Numerics.Reals;
   use Numerics.Fitting;
   use Internal_Messages;

   type Partial_Rule_Storage is tagged limited record
      Conclusion_Type : Internal_Type_Index := Internal_Type_Index'First;
      Id              : Positive := Positive'First;
      Fitting_Nbr     : Count := Count'First;
      Relevance       : Real_Accurately_0_To_1 := Real_Accurately_0_To_1'First;
      Credibility     : Real_0_To_1 := Real_0_To_1'First;
   end record;

   type Full_Rule_Storage is new Partial_Rule_Storage with record
      Internal_Conclusion           : aliased Conclusions.Internal_Conclusion;
      Internal_Condition            : aliased Internal_Premises;
      Internal_Condition_Types      : aliased Internal_Premises_Types;
      Internal_Condition_Properties : aliased Internal_Premises_Properties;
      Internal_Premises_Number      : Premise_Index := Premise_Index'First;
      External_Conclusion           : aliased External_Message;
      External_Conclusion_Size      : Component_Index;
      External_Condition            : aliased External_Premise;
      External_Condition_Type       : External_Type_Index := External_Type_Index'First;
   end record;

end Nomo.Gen_Rule_Storages;
