--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Reals;

with Nomo.Numerics.Times;

with Nomo.Numerics.Fitting;

with Nomo.Numerics.Accurately;

with Nomo.Numerics.Informations;

private generic
   Number_Of_External_Operators : Natural;
   Number_Of_Internal_Operators : Natural;
   type Internal_Type_Index is (<>);
package Nomo.Gen_Operators is

   pragma Pure;

   use Numerics.Reals;
   use Numerics.Times;
   use Numerics.Fitting;
   use Numerics.Accurately;
   use Numerics.Informations;

   type Operator_Without_Parameter is (Null_Operator,
                                       Get_After,
                                       Get_Before,
                                       Get_First,
                                       Get_Last,
                                       Get_Same,
                                       Get_There,
                                       Copy,
                                       Create_Check_Forward,
                                       Create_Command,
                                       Create_Conception,
                                       Create_Landmark,
                                       Create_Perception_Forward,
                                       Create_Prediction,
                                       Create_Reward,
                                       Create_Twin,
                                       Target,
                                       Transform_In_Temporal_Reference,
                                       Transform_In_Temporal_Reference_And_Origin,
                                       Forward,
                                       Backward,
                                       Same_Time
                                       );

   type External_Operator is record
      Information_Tolerance : Positive_Real;
   end record;
   First_External_Operator_With_Parameters : constant Positive := Operator_Without_Parameter'Pos(Get_There) + 1;
   type External_Operators is array (First_External_Operator_With_Parameters .. Number_Of_External_Operators) of External_Operator;

   type Internal_Operator is record
      Is_Conclusion         : Boolean := False;
      Relevance             : Real_Accurately_0_To_1;
      Fitting_Nbr           : Count;
      Time_Span_Value       : Time_Interval;
      Time_Span_Imposed     : Boolean := False;
      Time_Span_Tolerance   : Positive_Real;
      Credibility_Value     : Real_0_To_1;
      Credibility_Imposed   : Boolean := False;
      Credibility_Tolerance : Positive_Real;
      Information_Value     : Positive_Integer;
      Information_Imposed   : Boolean := False;
      Information_Tolerance : Boolean;
      Type_Value            : Internal_Type_Index;
      Type_Imposed          : Boolean := False;
   end record;
   First_Internal_Operator_With_Parameters : constant Positive := Operator_Without_Parameter'Pos(Operator_Without_Parameter'Last) + 1;
   type Internal_Operators is array (First_Internal_Operator_With_Parameters .. Number_Of_Internal_Operators) of Internal_Operator;

end Nomo.Gen_Operators;
