--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Accurately;

with Nomo.Gen_Integrations_Arrays;

generic
   type Local_External_Message is new External_Message;
   with package Integrations_Arrays is new Nomo.Gen_Integrations_Arrays(Component_Index);
package Nomo.Gen_External_Messages.Premises is

   pragma Pure;

   use Integrations_Arrays;
   use Numerics.Accurately;

   type External_Premise is tagged limited record
      Actuator        : Local_External_Message  := (others => 0.0);
      Information     : Local_External_Message  := (others => 0.0);
      Tolerance       : Tolerances_Array := (others => Positive_Infinity);
      Trend           : Integrations_Array;
      Size            : Component_Index := Component_Index'First;
      Specificity_Log : Real_Accurately := 0.0;
   end record;

end Nomo.Gen_External_Messages.Premises;
