﻿//  Copyright (2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published
//  by the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program. If not, see <http://www.gnu.org/licenses/>

#ifndef BENCHMARK_H
#define BENCHMARK_H

#include "nomointerpreter.h"

#ifdef WIN32
#define EXPORT __declspec(dllexport)
#else
#define EXPORT
#endif

extern EXPORT void benchmarkInitialize (const char* dirMap, const short nbrAgents, const char* dirLog, const int dirLength);

extern EXPORT void benchmarkUpdateMap ();

extern EXPORT void benchmarkSaveMap ();

extern EXPORT void benchmarkTriggers ();

extern EXPORT void benchmarkTriggersWithLog (const nomoLogFlag logFlag, const nomoLogPositionFlag logPositionFlag, const nomoFileFlag fileFlag);

extern EXPORT void benchmarkTriggersWithSave ();

extern EXPORT void benchmarkTriggersWithLogWithSave (const nomoLogFlag logFlag, const nomoLogPositionFlag logPositionFlag, const nomoFileFlag fileFlag);

extern EXPORT void benchmarkFinalize (const nomoFinalizationFlag finalizationFlag);

#endif // BENCHMARK_H
