<?xml version="1.0" encoding="utf-8" ?>
<!--
  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see <http://www.gnu.org/licenses/>
-->

<!--
S'applique sur un modèle, un programme ou une unité de compilation.
Met à jour les identifiants des models dans les éléments "program".
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:unit="http://www.nomoseed.org/unit" xmlns:program="http://www.nomoseed.org/program" xmlns:model="http://www.nomoseed.org/model" xmlns:plant="http://www.nomoseed.org/plant" xmlns:project="http://www.nomoseed.org/project">
	<xsl:output method="xml" indent="no"/>
	<xsl:template match="program:program">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
      <xsl:if test="@xml:base">
        <xsl:attribute name="xml:base">
          <xsl:value-of select="@xml:base"/>
        </xsl:attribute>
      </xsl:if>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:programs | program:body | program:models | program:rules">
		<xsl:copy>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:programs/program:new | program:programs/program:inherite">
		<xsl:copy>
			<xsl:attribute name="instance">
				<xsl:value-of select="@instance"/>
			</xsl:attribute>
      <xsl:attribute name="programID">
        <xsl:value-of select="@programID"/>
      </xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:models/program:new">
		<xsl:copy>
			<xsl:attribute name="instance">
				<xsl:value-of select="@instance"/>
			</xsl:attribute>
			<xsl:attribute name="prototype">
				<xsl:value-of select="@prototype"/>
			</xsl:attribute>
			<xsl:attribute name="model">
				<xsl:value-of select="@model"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:models/program:import">
		<xsl:copy>
			<xsl:attribute name="instance">
				<xsl:value-of select="@instance"/>
			</xsl:attribute>
			<xsl:attribute name="program">
				<xsl:value-of select="@program"/>
			</xsl:attribute>
			<xsl:attribute name="prototype">
				<xsl:value-of select="@prototype"/>
			</xsl:attribute>
			<xsl:attribute name="model">
				<xsl:value-of select="@model"/>
			</xsl:attribute>
      <xsl:attribute name="programID">
        <xsl:value-of select="@programID"/>
      </xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:models/program:inherite">
	<xsl:copy>
			<xsl:attribute name="instance">
				<xsl:value-of select="@instance"/>
			</xsl:attribute>
			<xsl:attribute name="prototype">
				<xsl:value-of select="@prototype"/>
			</xsl:attribute>
			<xsl:attribute name="model">
				<xsl:value-of select="@model"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="unit:unit">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:attribute name="multiplexer">
				<xsl:value-of select="@multiplexer"/>
			</xsl:attribute>
			<xsl:attribute name="binaryLocation">
				<xsl:value-of select="@binaryLocation"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:scheme">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:rule">
		<xsl:copy>
			<xsl:attribute name="fitting_nbr">
				<xsl:value-of select="@fitting_nbr"/>
			</xsl:attribute>
			<xsl:attribute name="relevance">
				<xsl:value-of select="@relevance"/>
			</xsl:attribute>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:*[not(@*)]">
		<xsl:copy>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:premise">
		<xsl:copy>
			<xsl:attribute name="id">
				<xsl:value-of select="@id"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:conclusion/program:information">
		<xsl:copy>
			<xsl:attribute name="value">
				<xsl:value-of select="@value"/>
			</xsl:attribute>
			<xsl:attribute name="type">
				<xsl:value-of select="@type"/>
			</xsl:attribute>
			<xsl:attribute name="model">
				<xsl:variable name="model" select="@model"/>
				<xsl:value-of select="ancestor::program:body/program:models/program:*[@oldModel=$model]/@model"/>
			</xsl:attribute>
			<xsl:if test="@delay">
				<xsl:attribute name="delay">
					<xsl:value-of select="@delay"/>
				</xsl:attribute>
			</xsl:if>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:premise/program:information[not(@next)]">
		<xsl:copy>
			<xsl:attribute name="value">
				<xsl:value-of select="@value"/>
			</xsl:attribute>
			<xsl:attribute name="type">
				<xsl:value-of select="@type"/>
			</xsl:attribute>
			<xsl:attribute name="tolerance">
				<xsl:value-of select="@tolerance"/>
			</xsl:attribute>
			<xsl:attribute name="model">
				<xsl:variable name="model" select="@model"/>
				<xsl:value-of select="ancestor::program:body/program:models/program:*[@oldModel=$model]/@model"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:premise/program:information[@next] | program:information[@next]">
		<xsl:copy>
			<xsl:attribute name="value">
				<xsl:value-of select="@value"/>
			</xsl:attribute>
			<xsl:attribute name="type">
				<xsl:value-of select="@type"/>
			</xsl:attribute>
			<xsl:attribute name="next">
				<xsl:value-of select="@next"/>
			</xsl:attribute>
			<xsl:attribute name="pos">
				<xsl:value-of select="@pos"/>
			</xsl:attribute>
			<xsl:attribute name="tolerance">
				<xsl:value-of select="@tolerance"/>
			</xsl:attribute>
			<xsl:attribute name="model">
				<xsl:variable name="model" select="@model"/>
				<xsl:value-of select="ancestor::program:body/program:models/program:*[@oldModel=$model]/@model"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:output">
		<xsl:copy>
			<xsl:attribute name="value">
				<xsl:value-of select="@value"/>
			</xsl:attribute>
			<xsl:attribute name="type">
				<xsl:value-of select="@type"/>
			</xsl:attribute>
			<xsl:attribute name="next">
				<xsl:value-of select="@next"/>
			</xsl:attribute>
			<xsl:attribute name="pos">
				<xsl:value-of select="@pos"/>
			</xsl:attribute>
			<xsl:attribute name="model">
				<xsl:variable name="model" select="@model"/>
				<xsl:value-of select="ancestor::program:body/program:models/program:*[@oldModel=$model]/@model"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="model:model">
		<xsl:choose>
			<xsl:when test="//model:plant_structure">
        <xsl:copy>
          <xsl:attribute name="name">
            <xsl:value-of select="@name"/>
          </xsl:attribute>
          <xsl:if test="@xml:base">
            <xsl:attribute name="xml:base">
              <xsl:value-of select="@xml:base"/>
            </xsl:attribute>
          </xsl:if>
          <xsl:apply-templates/>
        </xsl:copy>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy-of select="."/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="model:definition">
		<xsl:copy>
			<xsl:attribute name="model">
				<xsl:value-of select="@model"/>
			</xsl:attribute>
			<xsl:attribute name="base">
				<xsl:value-of select="@base"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="model:plant_structure">
		<xsl:copy>
      <xsl:variable name="program" select="ancestor::program:program[1]"/>
			<xsl:attribute name="extension">
				<xsl:value-of select="@extension"/>
			</xsl:attribute>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:apply-templates>
				<xsl:with-param name="program" select="$program"/>
			</xsl:apply-templates>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="plant:registers_structure">
		<xsl:param name="program"/>
		<xsl:copy>
			<xsl:apply-templates>
				<xsl:with-param name="program" select="$program"/>
			</xsl:apply-templates>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="plant:input | plant:other | plant:scope_type| plant:operator_type | plant:premise">
		<xsl:param name="program"/>
		<xsl:copy>
			<xsl:apply-templates>
				<xsl:with-param name="program" select="$program"/>
			</xsl:apply-templates>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="plant:other/plant:operator_type/plant:item">
		<xsl:param name="program"/>
		<xsl:copy>
			<xsl:attribute name="model">
				<xsl:value-of select="@model"/>
			</xsl:attribute>
			<xsl:attribute name="base">
				<xsl:value-of select="@base"/>
			</xsl:attribute>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="plant:premise">
		<xsl:param name="program"/>
		<xsl:copy>
			<xsl:attribute name="information_tolerance">
				<xsl:value-of select="@information_tolerance"/>
			</xsl:attribute>
			<xsl:attribute name="timespan_tolerance">
				<xsl:value-of select="@timespan_tolerance"/>
			</xsl:attribute>
			<xsl:attribute name="credibility_tolerance">
				<xsl:value-of select="@credibility_tolerance"/>
			</xsl:attribute>
			<xsl:attribute name="item">
				<xsl:value-of select="@item"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="plant:conclusion">
		<xsl:param name="program"/>
		<xsl:copy>
			<xsl:attribute name="fitting_nbr">
				<xsl:value-of select="@fitting_nbr"/>
			</xsl:attribute>
			<xsl:attribute name="relevance">
				<xsl:value-of select="@relevance"/>
			</xsl:attribute>
			<xsl:attribute name="item">
				<xsl:value-of select="@item"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="plant:conclusion/plant:*[not(./@*)] | plant:premise/plant:*[not(./@*)]">
		<xsl:copy>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="plant:target">
		<xsl:copy>
      <xsl:variable name="plant" select="//plant:plant_structure/@name"/>
      <xsl:attribute name="item">
        <xsl:value-of select="@item"/>
      </xsl:attribute>
      <xsl:attribute name="model">
        <xsl:choose>
          <xsl:when test="@model = 'plant' and $plant">
            <xsl:value-of select="//plant:plant_structure/@name"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="@model"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <xsl:attribute name="type">
        <xsl:value-of select="@type"/>
      </xsl:attribute>
      <xsl:attribute name="category">
        <xsl:value-of select="@category"/>
      </xsl:attribute>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="plant:information">
		<xsl:copy>
      <xsl:variable name="plant" select="//plant:plant_structure/@name"/>
      <xsl:attribute name="item">
        <xsl:value-of select="@item"/>
      </xsl:attribute>
      <xsl:attribute name="model">
        <xsl:choose>
          <xsl:when test="@model = 'plant' and $plant">
            <xsl:value-of select="//plant:plant_structure/@name"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="@model"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <xsl:attribute name="type">
        <xsl:value-of select="@type"/>
      </xsl:attribute>
      <xsl:attribute name="value">
        <xsl:value-of select="@value"/>
      </xsl:attribute>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="plant:scope_type/plant:item">
		<xsl:param name="program"/>
		<xsl:variable name="target_type" select="./plant:target/@type"/>
		<xsl:variable name="target_category" select="./plant:target/@category"/>
		<xsl:variable name="target_model" select="./plant:target/@model"/>
		<xsl:variable name="item" select="./plant:target/@item"/>
		<xsl:copy>
			<xsl:attribute name="model">
				<xsl:value-of select="@model"/>
			</xsl:attribute>
			<xsl:attribute name="base">
				<xsl:value-of select="@base"/>
			</xsl:attribute>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:choose>
				<xsl:when test="$program">
					<xsl:variable name="declarations" select="//plant:declaration[ancestor::program:program[$program] and (contains($target_type, @type) or contains($target_type, '*')) and (contains($target_category, @category) or (contains($target_category, '*') and not(contains(@category, 'input')))) and (contains($target_model, 'plant') or contains($target_model, '*'))] | //model:declaration[ not(ancestor::program:import) and not(ancestor::model:base) and ancestor::program:program[$program] and (contains($target_type, @type)  or contains($target_type, '*'))and (contains($target_category, @category) or (contains($target_category, '*') and not(contains(@category, 'input')))) and (contains($target_model, @model) or contains($target_model, '*'))]"/>
          <xsl:for-each select="$declarations">
						<xsl:element name="target" namespace="http://www.nomoseed.org/plant">
              <xsl:attribute name="item">
                <xsl:value-of select="$item"/>
              </xsl:attribute>
							<xsl:attribute name="model">
								<xsl:value-of select="@model"/>
							</xsl:attribute>
							<xsl:attribute name="type">
								<xsl:value-of select="@type"/>
							</xsl:attribute>
							<xsl:attribute name="category">
								<xsl:value-of select="@category"/>
							</xsl:attribute>
						</xsl:element>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<xsl:element name="target" namespace="http://www.nomoseed.org/plant">
						<xsl:attribute name="item">
							<xsl:value-of select="@name"/>
						</xsl:attribute>
						<xsl:attribute name="model">
							<xsl:value-of select="'default'"/>
						</xsl:attribute>
						<xsl:attribute name="type">
							<xsl:value-of select="'default'"/>
						</xsl:attribute>
						<xsl:attribute name="category">
							<xsl:variable name="list" select="normalize-space($target_category)"/>
							<xsl:choose>
								<xsl:when test="contains($list, ' ')">
									<xsl:value-of select="substring-before ($list, ' ')"/>
								</xsl:when>
								<xsl:when test="contains($list, '*')">
									<xsl:value-of select="'conception'"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$list"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
					</xsl:element>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="*">
		<xsl:copy-of select="."/>
	</xsl:template>
</xsl:stylesheet>
