<?xml version="1.0" encoding="utf-8" ?>
<!--
  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see <http://www.gnu.org/licenses/>
-->

<!--
	Transforme un programme suivant une grammaire basique ambigue en un programme respectant une grammaire non ambigu.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:unit="http://www.nomoseed.org/unit" xmlns:program="http://www.nomoseed.org/program" xmlns:model="http://www.nomoseed.org/model" xmlns:project="http://www.nomoseed.org/project">
	<xsl:output method="xml" indent="yes"/>
	<xsl:include href="link_0-model.xsl"/>
	<xsl:include href="link_0-plant.xsl"/>
  <xsl:variable name="others_registers_nbr">
    <xsl:call-template name="get_others_registers_nbr">
      <xsl:with-param name="list" select="//model:plant_structure"/>
    </xsl:call-template>
  </xsl:variable>
	<xsl:template match="program:program">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:copy-of select="./project:header"/>
			<xsl:apply-templates select="./program:subprograms"/>
			<xsl:apply-templates select="./program:body"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:subprograms">
		<xsl:element name="programs" namespace="http://www.nomoseed.org/program">
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="program:subprograms/program:new | program:subprograms/program:inherite">
		<xsl:copy>
			<xsl:attribute name="instance">
				<xsl:value-of select="@instance"/>
			</xsl:attribute>
			<xsl:attribute name="programID">
				<xsl:value-of select="generate-id(./ancestor::program:program[1])"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:body">
		<xsl:copy>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:models">
		<xsl:copy>
      <xsl:if test="count(.//model:plant_structure) != 0 or (parent::program:body/parent::program:program/parent::unit:unit and count(//model:plant_structure) != 0)">
        <xsl:call-template name="create_plant">
          <xsl:with-param name="others_registers_nbr" select="$others_registers_nbr"/>
        </xsl:call-template>
			</xsl:if>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template name="get_others_registers_nbr">
		<xsl:param name="n" select="1"/>
		<xsl:param name="list"/>
		<xsl:param name="max" select="0"/>
		<xsl:choose>
			<xsl:when test="$list[position()=$n]">
				<xsl:variable name="value">
					<xsl:choose>
						<xsl:when test="$max &lt; $list[position()=$n]/@others_registers_nbr">
							<xsl:value-of select="$list[position()=$n]/@others_registers_nbr"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$max"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:call-template name="get_others_registers_nbr">
					<xsl:with-param name="n" select="$n + 1"/>
					<xsl:with-param name="list" select="$list"/>
					<xsl:with-param name="max" select="$value"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$max"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="program:models/program:new | program:models/program:inherite">
		<xsl:copy>
			<xsl:attribute name="instance">
				<xsl:value-of select="@instance"/>
			</xsl:attribute>
			<xsl:attribute name="prototype">
				<xsl:value-of select="./model:model/@name"/>
			</xsl:attribute>
			<xsl:attribute name="model">
				<xsl:value-of select="@instance"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:models/program:import">
		<xsl:copy>
			<xsl:attribute name="instance">
				<xsl:value-of select="@instance"/>
			</xsl:attribute>
			<xsl:attribute name="prototype">
				<xsl:value-of select="./model:model/@name"/>
			</xsl:attribute>
			<xsl:attribute name="program">
				<xsl:value-of select="@subprogram"/>
			</xsl:attribute>
			<xsl:attribute name="model">
				<xsl:value-of select="@instance"/>
			</xsl:attribute>
			<xsl:attribute name="programID">
				<xsl:value-of select="generate-id(./ancestor::program:program[1])"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:scheme">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:if test="@name">
					<xsl:value-of select="@name"/>
				</xsl:if>
				<xsl:value-of select="../../@name"/>
			</xsl:attribute>
			<xsl:copy-of select="./project:annotation"/>
			<xsl:if test="./program:rule">
				<xsl:element name="rules" namespace="http://www.nomoseed.org/program">
					<xsl:call-template name="create_category">
						<xsl:with-param name="list" select="./program:rule[./program:conclusion/@category='command']"/>
						<xsl:with-param name="category" select="'command'"/>
					</xsl:call-template>
					<xsl:call-template name="create_category">
						<xsl:with-param name="list" select="./program:rule[./program:conclusion/@category='perception']"/>
						<xsl:with-param name="category" select="'perception'"/>
					</xsl:call-template>
					<xsl:call-template name="create_category">
						<xsl:with-param name="list" select="./program:rule[./program:conclusion/@category='conception']"/>
						<xsl:with-param name="category" select="'conception'"/>
					</xsl:call-template>
					<xsl:call-template name="create_category">
						<xsl:with-param name="list" select="./program:rule[./program:conclusion/@category='prediction']"/>
						<xsl:with-param name="category" select="'prediction'"/>
					</xsl:call-template>
					<xsl:call-template name="create_category">
						<xsl:with-param name="list" select="./program:rule[./program:conclusion/@category='landmark']"/>
						<xsl:with-param name="category" select="'landmark'"/>
					</xsl:call-template>
					<xsl:call-template name="create_category">
						<xsl:with-param name="list" select="./program:rule[./program:conclusion/@category='operator' and ./program:conclusion/@type='register_00']"/>
						<xsl:with-param name="category" select="'input_operator'"/>
					</xsl:call-template>
					<xsl:call-template name="create_category">
						<xsl:with-param name="list" select="./program:rule[./program:conclusion/@category='scope' and ./program:conclusion/@type='register_00']"/>
						<xsl:with-param name="category" select="'input_scope'"/>
					</xsl:call-template>
					<xsl:call-template name="create_category">
						<xsl:with-param name="list" select="./program:rule[./program:conclusion/@category='operator' and ./program:conclusion/@type!='register_00']"/>
						<xsl:with-param name="category" select="'other_operator'"/>
					</xsl:call-template>
					<xsl:call-template name="create_category">
						<xsl:with-param name="list" select="./program:rule[./program:conclusion/@category='scope' and ./program:conclusion/@type!='register_00']"/>
						<xsl:with-param name="category" select="'other_scope'"/>
					</xsl:call-template>
					<xsl:call-template name="create_category">
						<xsl:with-param name="list" select="./program:rule[./program:conclusion/@category='transition']"/>
						<xsl:with-param name="category" select="'transition'"/>
					</xsl:call-template>
					<xsl:call-template name="create_category">
						<xsl:with-param name="list" select="./program:rule[./program:conclusion/@category='check']"/>
						<xsl:with-param name="category" select="'check'"/>
					</xsl:call-template>
					<xsl:call-template name="create_category">
						<xsl:with-param name="list" select="./program:rule[./program:conclusion/@category='reward']"/>
						<xsl:with-param name="category" select="'reward'"/>
					</xsl:call-template>
				</xsl:element>
			</xsl:if>
			<xsl:apply-templates select="./program:scheme"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template name="create_category">
		<xsl:param name="list"/>
		<xsl:param name="category"/>
		<xsl:if test="$list">
			<xsl:element name="{$category}" namespace="http://www.nomoseed.org/program">
				<xsl:apply-templates select="$list"/>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<xsl:template match="program:rule">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:attribute name="fitting_nbr">
				<xsl:choose>
					<xsl:when test="@fitting_nbr">
						<xsl:value-of select="@fitting_nbr"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'INF'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:attribute name="relevance">
				<xsl:choose>
					<xsl:when test="@relevance">
						<xsl:value-of select="@relevance"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'1.0'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:copy-of select="./project:annotation"/>
			<xsl:call-template name="create_premises">
				<xsl:with-param name="list" select="./program:premise[@inhibitor]"/>
				<xsl:with-param name="property" select="'inhibitory'"/>
			</xsl:call-template>
			<xsl:call-template name="create_premises">
				<xsl:with-param name="list" select="./program:premise[not(@inhibitor)]"/>
				<xsl:with-param name="property" select="'excitatory'"/>
			</xsl:call-template>
      <xsl:if test="not(./program:premise)">
        <xsl:element name="excitatory" namespace="http://www.nomoseed.org/program"/>
      </xsl:if>
			<xsl:apply-templates select="./program:conclusion"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template name="create_premises">
		<xsl:param name="list"/>
		<xsl:param name="property"/>
		<xsl:if test="$list">
			<xsl:element name="{$property}" namespace="http://www.nomoseed.org/program">
				<xsl:call-template name="create_category">
					<xsl:with-param name="list" select="$list[@category='command']"/>
					<xsl:with-param name="category" select="'command'"/>
				</xsl:call-template>
				<xsl:call-template name="create_category">
					<xsl:with-param name="list" select="$list[@category='input']"/>
					<xsl:with-param name="category" select="'input'"/>
				</xsl:call-template>
				<xsl:call-template name="create_category">
					<xsl:with-param name="list" select="$list[@category='perception']"/>
					<xsl:with-param name="category" select="'perception'"/>
				</xsl:call-template>
				<xsl:call-template name="create_category_intention">
					<xsl:with-param name="list" select="$list[@category='conception']"/>
					<xsl:with-param name="category" select="'conception'"/>
				</xsl:call-template>
				<xsl:call-template name="create_category_intention">
					<xsl:with-param name="list" select="$list[@category='prediction']"/>
					<xsl:with-param name="category" select="'prediction'"/>
				</xsl:call-template>
				<xsl:call-template name="create_category">
					<xsl:with-param name="list" select="$list[@category='landmark']"/>
					<xsl:with-param name="category" select="'landmark'"/>
				</xsl:call-template>
				<xsl:call-template name="create_category">
					<xsl:with-param name="list" select="$list[@category='operator' and @type='register_00']"/>
					<xsl:with-param name="category" select="'input_operator'"/>
				</xsl:call-template>
				<xsl:call-template name="create_category">
					<xsl:with-param name="list" select="$list[@category='scope' and @type='register_00']"/>
					<xsl:with-param name="category" select="'input_scope'"/>
				</xsl:call-template>
				<xsl:call-template name="create_category">
					<xsl:with-param name="list" select="$list[@category='operator' and @type!='register_00']"/>
					<xsl:with-param name="category" select="'other_operator'"/>
				</xsl:call-template>
				<xsl:call-template name="create_category">
					<xsl:with-param name="list" select="$list[@category='scope' and @type!='register_00']"/>
					<xsl:with-param name="category" select="'other_scope'"/>
				</xsl:call-template>
				<xsl:call-template name="create_category">
					<xsl:with-param name="list" select="$list[@category='transition']"/>
					<xsl:with-param name="category" select="'transition'"/>
				</xsl:call-template>
				<xsl:call-template name="create_category">
					<xsl:with-param name="list" select="$list[@category='anomaly']"/>
					<xsl:with-param name="category" select="'anomaly'"/>
				</xsl:call-template>
				<xsl:call-template name="create_category">
					<xsl:with-param name="list" select="$list[@category='check']"/>
					<xsl:with-param name="category" select="'check'"/>
				</xsl:call-template>
				<xsl:call-template name="create_category">
					<xsl:with-param name="list" select="$list[@category='reward' ]"/>
					<xsl:with-param name="category" select="'reward'"/>
				</xsl:call-template>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<xsl:template match="program:conclusion">
		<xsl:copy>
			<xsl:element name="information" namespace="http://www.nomoseed.org/program">
				<xsl:if test="./program:information/@value">
					<xsl:attribute name="value">
						<xsl:value-of select="./program:information/@value"/>
					</xsl:attribute>
				</xsl:if>
				<xsl:if test="./program:information/@credibility_tolerance">
					<xsl:attribute name="credibility_tolerance">
						<xsl:value-of select="./program:information/@credibility_tolerance"/>
					</xsl:attribute>
				</xsl:if>
				<xsl:if test="./program:information/@timespan_tolerance">
					<xsl:attribute name="timespan_tolerance">
						<xsl:value-of select="./program:information/@timespan_tolerance"/>
					</xsl:attribute>
				</xsl:if>
				<xsl:if test="./program:information/@information_tolerance">
					<xsl:attribute name="information_tolerance">
						<xsl:value-of select="./program:information/@information_tolerance"/>
					</xsl:attribute>
				</xsl:if>
				<xsl:if test="./program:information/@relevance">
					<xsl:attribute name="relevance">
						<xsl:value-of select="./program:information/@relevance"/>
					</xsl:attribute>
				</xsl:if>
				<xsl:if test="./program:information/@fitting_nbr">
					<xsl:attribute name="fitting_nbr">
						<xsl:value-of select="./program:information/@fitting_nbr"/>
					</xsl:attribute>
				</xsl:if>
				<xsl:if test="./program:information/@target_type">
					<xsl:attribute name="target_type">
						<xsl:value-of select="./program:information/@target_type"/>
					</xsl:attribute>
				</xsl:if>
				<xsl:if test="./program:information/@target_model">
					<xsl:attribute name="target_cmodel">
						<xsl:value-of select="./program:information/@target_model"/>
					</xsl:attribute>
				</xsl:if>
				<xsl:if test="./program:information/@target_category">
					<xsl:attribute name="target_category">
						<xsl:value-of select="./program:information/@target_category"/>
					</xsl:attribute>
				</xsl:if>
				<xsl:attribute name="type">
					<xsl:value-of select="@type"/>
				</xsl:attribute>
				<xsl:attribute name="model">
					<xsl:value-of select="@model"/>
				</xsl:attribute>
				<xsl:if test="@category='conception' or @category='prediction'">
					<xsl:choose>
						<xsl:when test="./program:information/@delay">
							<xsl:attribute name="delay">
                <xsl:choose>
                  <xsl:when test="contains(./program:information/@delay, 'MAX')">
                      <xsl:choose>
                        <xsl:when test="not(contains(./program:timespan/@value, '-'))">
                          <xsl:value-of select="'MAX'"/>
                        </xsl:when>
                        <xsl:when test="contains(./program:timespan/@value, 'ms')">
                          <xsl:value-of select="concat('MAX-', number(substring-before(substring-after(./program:timespan/@value,'MAX'),'ms')))"/>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:value-of select="concat('MAX-', format-number(number(concat('0',number(substring-after(./program:timespan/@value,'-')))) * $timestep, '#'))"/>
                        </xsl:otherwise>
                      </xsl:choose>
                  </xsl:when>
                  <xsl:when test="contains(./program:information/@delay, 'ms')">
                    <xsl:value-of select="number(substring-before(./program:information/@delay,'ms'))"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="format-number(number(./program:information/@delay) * $timestep, '#')"/>
                  </xsl:otherwise>
                </xsl:choose>
							</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="delay">
								<xsl:value-of select="'0'"/>
							</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</xsl:element>
			<xsl:if test="./program:output">
				<xsl:apply-templates select="./program:output[1]">
					<xsl:with-param name="type" select="@type"/>
					<xsl:with-param name="model" select="@model"/>
				</xsl:apply-templates>
			</xsl:if>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:output">
		<xsl:param name="type"/>
		<xsl:param name="model"/>
		<xsl:element name="output" namespace="http://www.nomoseed.org/program">
			<xsl:attribute name="type">
				<xsl:value-of select="$type"/>
			</xsl:attribute>
			<xsl:attribute name="model">
				<xsl:value-of select="$model"/>
			</xsl:attribute>
			<xsl:variable name="pos">
				<xsl:number count="program:output" format="1" level="single"/>
			</xsl:variable>
			<xsl:attribute name="pos">
				<xsl:value-of select="$pos"/>
			</xsl:attribute>
			<xsl:attribute name="value">
				<xsl:value-of select="@value"/>
			</xsl:attribute>
			<xsl:choose>
				<xsl:when test="following-sibling::program:output">
					<xsl:attribute name="next">
						<xsl:value-of select="$pos + 1"/>
					</xsl:attribute>
					<xsl:apply-templates select="following-sibling::program:output[1]">
						<xsl:with-param name="type" select="$type"/>
						<xsl:with-param name="model" select="$model"/>
					</xsl:apply-templates>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="next">
						<xsl:value-of select="'*'"/>
					</xsl:attribute>
					<xsl:element name="end" namespace="http://www.nomoseed.org/program">
						<xsl:attribute name="pos">
							<xsl:value-of select="'*'"/>
						</xsl:attribute>
					</xsl:element>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:element>
	</xsl:template>
	<xsl:template match="program:premise">
		<xsl:copy>
			<xsl:attribute name="id">
				<xsl:number level="single" count="program:premise" format="1"/>
			</xsl:attribute>
			<xsl:copy-of select="./project:annotation"/>
			<xsl:element name="information" namespace="http://www.nomoseed.org/program">
				<xsl:if test="not(./program:information/@category)">
					<xsl:attribute name="value">
						<xsl:choose>
							<xsl:when test="./program:information/@tolerance='INF'">
								<xsl:variable name="model" select="@model"/>
								<xsl:variable name="type" select="@type"/>
								<xsl:choose>
									<xsl:when test="@category='perception'">
										<xsl:value-of select="ancestor::program:program[1]/program:body/program:models/*[@instance=$model]/model:model/model:definition/model:perceptive_structure[@name=$type]/model:items/model:item[1]/@name"/>
									</xsl:when>
									<xsl:when test="@category='prediction' or @category='check'">
										<xsl:value-of select="ancestor::program:program[1]/program:body/program:models/*[@instance=$model]/model:model/model:definition/model:predictive_structure[@name=$type]/model:items/model:item[1]/@name"/>
									</xsl:when>
									<xsl:when test="@category='landmark'">
										<xsl:value-of select="ancestor::program:program[1]/program:body/program:models/*[@instance=$model]/model:model/model:definition/model:landmark_type[@name=$type]/model:items/model:item[1]/@name | ancestor::program:program[1]/program:body/program:models/*[@instance=$model]/model:model/model:definition/model:predictive_structure[@name=$type]/model:items/model:item[1]/@name"/>
									</xsl:when>
									<xsl:when test="@category='reward'">
										<xsl:value-of select="ancestor::program:program[1]/program:body/program:models/*[@instance=$model]/model:model/model:definition/model:reward_type[@name=$type]/model:items/model:item[1]/@name"/>
									</xsl:when>
									<xsl:when test="@category='conception'">
										<xsl:value-of select="ancestor::program:program[1]/program:body/program:models/*[@instance=$model]/model:model/model:definition/model:conception_type[@name=$type]/model:items/model:item[1]/@name"/>
									</xsl:when>
									<xsl:when test="@category='command'">
										<xsl:value-of select="ancestor::program:program[1]/program:body/program:models/*[@instance=$model]/model:model/model:definition/model:command_type[@name=$type]/model:items/model:item[1]/@name | ancestor::program:program[1]/program:body/program:models/*[@instance=$model]/model:model/model:definition/model:perceptive_structure[@name=$type]/model:command_type/model:items/model:item[1]/@name"/>
									</xsl:when>
									<xsl:when test="@category='transition'">
										<xsl:value-of select="'begin_affectation'"/>
									</xsl:when>
									<xsl:when test="@category='anomaly'">
										<xsl:value-of select="'affectation_expired_for_reference_time'"/>
									</xsl:when>
									<xsl:when test="@category='scope' and @type='register_00'">
										<xsl:value-of select="ancestor::program:program[1]/program:body/program:models/*[@instance=$model]/model:model/model:definition/model:plant_structure/model:input/model:scope_type/model:item[1]/@name"/>
									</xsl:when>
									<xsl:when test="@category='scope' and @type!='register_00'">
										<xsl:value-of select="ancestor::program:program[1]/program:body/program:models/*[@instance=$model]/model:model/model:definition/model:plant_structure/model:other/model:scope_type/model:item[1]/@name"/>
									</xsl:when>
									<xsl:when test="@category='operator'">
										<xsl:value-of select="'get_there'"/>
									</xsl:when>
									<xsl:otherwise/>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="./program:information/@value"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</xsl:if>
				<xsl:if test="./program:information/@credibility_tolerance">
					<xsl:attribute name="credibility_tolerance">
						<xsl:value-of select="./program:information/@credibility_tolerance"/>
					</xsl:attribute>
				</xsl:if>
				<xsl:if test="./program:information/@timespan_tolerance">
					<xsl:attribute name="timespan_tolerance">
            <xsl:choose>
              <xsl:when test="contains(./program:information/@timespan_tolerance, 'period')">
                <xsl:value-of select="number(substring-before(./program:information/@timespan_tolerance,'period')) * $timestep"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="./program:information/@timespan_tolerance"/>
              </xsl:otherwise>
            </xsl:choose>
					</xsl:attribute>
				</xsl:if>
				<xsl:if test="./program:information/@information_tolerance">
					<xsl:attribute name="information_tolerance">
						<xsl:value-of select="./program:information/@information_tolerance"/>
					</xsl:attribute>
				</xsl:if>
				<xsl:if test="./program:information/@relevance">
					<xsl:attribute name="relevance">
						<xsl:value-of select="./program:information/@relevance"/>
					</xsl:attribute>
				</xsl:if>
				<xsl:if test="./program:information/@fitting_nbr">
					<xsl:attribute name="fitting_nbr">
						<xsl:value-of select="./program:information/@fitting_nbr"/>
					</xsl:attribute>
				</xsl:if>
				<xsl:if test="./program:information/@target_ccategory">
					<xsl:attribute name="target_category">
						<xsl:value-of select="./program:information/@target_category"/>
					</xsl:attribute>
				</xsl:if>
				<xsl:if test="./program:information/@target_model">
					<xsl:attribute name="target_cmodel">
						<xsl:value-of select="./program:information/@target_model"/>
					</xsl:attribute>
				</xsl:if>
				<xsl:if test="./program:information/@target_category">
					<xsl:attribute name="target_ccategory">
						<xsl:value-of select="./program:information/@target_category"/>
					</xsl:attribute>
				</xsl:if>
				<xsl:attribute name="tolerance">
					<xsl:value-of select="./program:information/@tolerance"/>
				</xsl:attribute>
				<xsl:attribute name="type">
					<xsl:value-of select="@type"/>
				</xsl:attribute>
				<xsl:attribute name="model">
					<xsl:value-of select="@model"/>
				</xsl:attribute>
			</xsl:element>
			<xsl:element name="credibility" namespace="http://www.nomoseed.org/program">
        <xsl:choose>
          <xsl:when test="./program:credibility">
            <xsl:attribute name="tolerance">
              <xsl:value-of select="./program:credibility/@tolerance"/>
            </xsl:attribute>
            <xsl:attribute name="value">
              <xsl:choose>
                <xsl:when test="./program:credibility/@tolerance='INF'">
                  <xsl:value-of select="'1.0'"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="./program:credibility/@value"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="tolerance">
              <xsl:value-of select="'INF'"/>
            </xsl:attribute>
            <xsl:attribute name="value">
              <xsl:value-of select="'1.0'"/>
            </xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
			</xsl:element>
			<xsl:element name="timespan" namespace="http://www.nomoseed.org/program">
        <xsl:choose>
          <xsl:when test="./program:timespan">
            <xsl:attribute name="tolerance">
              <xsl:choose>
                <xsl:when test="contains(./program:timespan/@tolerance, 'period')">
                  <xsl:value-of select="number(substring-before(./program:timespan/@tolerance,'period')) * $timestep"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="./program:timespan/@tolerance"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:attribute>
            <xsl:attribute name="value">
              <xsl:choose>
                <xsl:when test="./program:timespan/@tolerance='INF'">
                  <xsl:choose>
                    <xsl:when test="contains(./program:timespan/@value, '-') and not(substring(./program:timespan/@value, 1, 3) = 'MAX') or contains(./program:timespan/@value, 'MIN')">
                      <xsl:value-of select="'-1'"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="'1'"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:when>
                <xsl:otherwise>                  
                  <xsl:choose>
                    <xsl:when test="contains(./program:timespan/@value, 'MIN')">
                      <xsl:choose>
                        <xsl:when test="not(contains(./program:timespan/@value, '+'))">
                          <xsl:value-of select="'MIN'"/>
                        </xsl:when>
                        <xsl:when test="contains(./program:timespan/@value, 'ms')">
                          <xsl:value-of select="concat('MIN+', number(substring-before(substring-after(./program:timespan/@value,'+'),'ms')))"/>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:value-of select="concat('MIN+', format-number(number(concat('0',number(substring-after(./program:timespan/@value,'+')))) * $timestep, '#'))"/>
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:when>
                    <xsl:when test="contains(./program:timespan/@value, 'MAX')">
                      <xsl:choose>
                        <xsl:when test="contains(./program:timespan/@value, 'ms')">
                          <xsl:if test="number($time_span_max - number(substring-before(substring-after(./program:timespan/@value,'-'),'ms'))) &lt; 0">
                            <xsl:message terminate="no"><xsl:value-of select="concat(local-name(/*),' ',/*/@name, ' :')"/> Constraint error <xsl:value-of select="./program:timespan/@value"/> &lt; 0</xsl:message>
                          </xsl:if>
                          <xsl:value-of select="format-number($time_span_max - number(substring-before(substring-after(./program:timespan/@value,'-'),'ms')),'#')"/>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:if test="number($time_span_max - number(concat('0',number(substring-after(./program:timespan/@value,'-')))) * $timestep) &lt; 0">
                            <xsl:message terminate="no"><xsl:value-of select="concat(local-name(/*),' ',/*/@name, ' :')"/> Constraint error <xsl:value-of select="./program:timespan/@value"/> &lt; 0</xsl:message>
                          </xsl:if>
                          <xsl:value-of select="format-number($time_span_max - number(concat('0',number(substring-after(./program:timespan/@value,'-')))) * $timestep,'#')"/>
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:when>
                    <xsl:when test="contains(./program:timespan/@value, 'ms')">
                      <xsl:if test="$time_span_limit &lt; number(substring-before(./program:timespan/@value,'ms'))">
                        <xsl:message terminate="no"><xsl:value-of select="concat(local-name(/*),' ',/*/@name, ' :')"/> Constraint error time_span_limit &lt; <xsl:value-of select="number(substring-before(./program:timespan/@value,'ms'))"/></xsl:message>
                      </xsl:if>
                      <xsl:value-of select="number(substring-before(./program:timespan/@value,'ms'))"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:if test="$time_span_limit &lt; number(./program:timespan/@value) * $timestep">
                        <xsl:message terminate="no"><xsl:value-of select="concat(local-name(/*),' ',/*/@name, ' :')"/> Constraint error time_span_limit &lt; <xsl:value-of select="number(./program:timespan/@value) * $timestep"/></xsl:message>
                      </xsl:if>
                      <xsl:value-of select="format-number(number(./program:timespan/@value) * $timestep, '#')"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="tolerance">
              <xsl:value-of select="'INF'"/>
            </xsl:attribute>
            <xsl:attribute name="value">
              <xsl:value-of select="'1'"/>
            </xsl:attribute>
          </xsl:otherwise>
        </xsl:choose>
			</xsl:element>
		</xsl:copy>
	</xsl:template>
	<xsl:template name="create_category_intention">
		<xsl:param name="list"/>
		<xsl:param name="category"/>
		<xsl:if test="$list">
			<xsl:element name="{$category}" namespace="http://www.nomoseed.org/program">
				<xsl:apply-templates select="$list[not(contains(./program:timespan/@value, '-') and not(substring(./program:timespan/@value, 1, 3) = 'MAX') or contains(./program:timespan/@value, 'MIN'))] | $list[not(./program:timespan)]"/>
				<xsl:if test="$list[contains(./program:timespan/@value, '-') and not(substring(./program:timespan/@value, 1, 3) = 'MAX') or contains(./program:timespan/@value, 'MIN')]">
					<xsl:element name="intention" namespace="http://www.nomoseed.org/program">
						<xsl:apply-templates select="$list[contains(./program:timespan/@value, '-') and not(substring(./program:timespan/@value, 1, 3) = 'MAX') or contains(./program:timespan/@value, 'MIN')]"/>
					</xsl:element>
				</xsl:if>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<xsl:template match="program:premise[@category='input']">
		<xsl:copy>
			<xsl:attribute name="id">
				<xsl:number level="single" count="program:premise" format="1"/>
			</xsl:attribute>
			<xsl:copy-of select="./project:annotation"/>
			<xsl:apply-templates select="./program:information[1]" mode="input">
				<xsl:with-param name="type" select="@type"/>
				<xsl:with-param name="model" select="@model"/>
			</xsl:apply-templates>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:information" mode="input">
		<xsl:param name="type"/>
		<xsl:param name="model"/>
		<xsl:element name="information" namespace="http://www.nomoseed.org/program">
			<xsl:attribute name="type">
				<xsl:value-of select="$type"/>
			</xsl:attribute>
			<xsl:attribute name="model">
				<xsl:value-of select="$model"/>
			</xsl:attribute>
			<xsl:variable name="pos">
				<xsl:number count="program:information" format="1" level="single"/>
			</xsl:variable>
			<xsl:attribute name="pos">
				<xsl:value-of select="$pos"/>
			</xsl:attribute>
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="@tolerance='INF'">
						<xsl:value-of select="0.0"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="@value"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:attribute name="tolerance">
				<xsl:value-of select="@tolerance"/>
			</xsl:attribute>
			<xsl:choose>
				<xsl:when test="following-sibling::program:information">
					<xsl:attribute name="next">
						<xsl:value-of select="$pos + 1"/>
					</xsl:attribute>
					<xsl:apply-templates select="following-sibling::program:information[1]" mode="input">
						<xsl:with-param name="type" select="$type"/>
						<xsl:with-param name="model" select="$model"/>
					</xsl:apply-templates>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="next">
						<xsl:value-of select="'*'"/>
					</xsl:attribute>
					<xsl:element name="end" namespace="http://www.nomoseed.org/program">
						<xsl:attribute name="pos">
							<xsl:value-of select="'*'"/>
						</xsl:attribute>
					</xsl:element>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>
