<?xml version="1.0" encoding="utf-8" standalone="yes"?>
<!--
  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see <http://www.gnu.org/licenses/>
-->
<!--
Génére une interface en langage Java pour une unité nomo donnée.
-->
<xsl:stylesheet version="1.0" xmlns:code="http://www.nomoseed.org/code" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:output method="text" encoding="utf-8"/>
	<xsl:template match="code:code">/* Interface for nomoInterpreter created with nomoSDK */

import com.sun.jna.Pointer;
  
public class <xsl:value-of select="@unit"/> {

<xsl:if test="code:types/code:type[@category='input']">    /* ID of input types */
    public static enum InputId {
        <xsl:apply-templates select="code:types/code:type[@category='input']"/>private final int id;
        private InputId(int value) {
            id = value;
        }
        public int getId() {
            return id;
        }
    }

</xsl:if>    /* Size of inputs and commands */
    public static enum DataSize{
        <xsl:apply-templates select="code:types/code:type[@data_size]" mode="size"/>private final int size;
        private DataSize(int value) {
            size = value;
        }
        public int getSize() {
            return size;
        }
    }

    /* Components of inputs and components of commands<xsl:if test="/code:code/@multiplexer = 'yes'"> with demultiplexing value</xsl:if> */<xsl:apply-templates select="code:types/code:type[@components]" mode="component"/>

   /* Command functions<xsl:if test="/code:code/@multiplexer = 'yes'"> with demultiplexing</xsl:if> */<xsl:choose>
			<xsl:when test="/code:code/@multiplexer = 'yes'">
				<xsl:apply-templates select="code:types/code:type[@category='command']" mode="functionMultiplexer"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="code:types/code:type[@category='command']" mode="function"/>
			</xsl:otherwise>
		</xsl:choose>

    public static final NomoInterpreter.NomoCallback [] callbacks = new NomoInterpreter.NomoCallback [] {
        <xsl:choose>
			<xsl:when test="/code:code/@multiplexer = 'yes'">
				<xsl:apply-templates select="code:types/code:type[@category='command']" mode="callbackMultiplexer"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="code:types/code:type[@category='command']" mode="callback"/>
			</xsl:otherwise>
		</xsl:choose>
    };

    /* ID of log types */
    public static enum LogId {
        <xsl:apply-templates select="code:types/code:type" mode="log"/>
    }

    public static final int TYPES_LOG_NUMBER = <xsl:value-of select="count(//code:type) - count(//code:type[@category='input'])"/>;

}</xsl:template>
	<xsl:template match="code:types/code:type[@category='input']">
    <xsl:variable name="external_name">
      <xsl:call-template name="normalize">
        <xsl:with-param name="name" select="@external_name"/>
      </xsl:call-template>
    </xsl:variable>
<xsl:call-template name="MAJ">
			<xsl:with-param name="text" select="$external_name"/>
		</xsl:call-template> (<xsl:value-of select="@id"/>)<xsl:if test="not(position()=last())">,</xsl:if><xsl:if test="position()=last()">;</xsl:if>  // <xsl:value-of select="@external_comment"/><xsl:text>
        </xsl:text></xsl:template>
	<xsl:template match="code:types/code:type[@components]" mode="component">
    <xsl:variable name="external_name">
      <xsl:call-template name="unique">
        <xsl:with-param name="name" select="@external_name"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:if test="not($external_name='')">
		<xsl:variable name="components">
			<xsl:call-template name="MAJ">
				<xsl:with-param name="text" select="@components"/>
			</xsl:call-template>
		</xsl:variable>
    public static enum <xsl:call-template name="replace">
			<xsl:with-param name="name" select="$external_name"/>
		</xsl:call-template>Component {<xsl:call-template name="components">
			<xsl:with-param name="name" select="$components"/>
			<xsl:with-param name="result" select="''"/>
		</xsl:call-template>
		<xsl:if test="@category='command' and /code:code/@multiplexer = 'yes'">, ID</xsl:if>}</xsl:if></xsl:template>
	<xsl:template match="code:types/code:type[@category!='input']" mode="log">
    <xsl:variable name="external_name">
      <xsl:call-template name="normalize">
        <xsl:with-param name="name" select="@external_name"/>
      </xsl:call-template>
    </xsl:variable>
<xsl:call-template name="MAJ">
			<xsl:with-param name="text" select="$external_name"/>
		</xsl:call-template><xsl:if test="not(position()=last())">,</xsl:if><xsl:if test="position()=last()">;</xsl:if> // <xsl:value-of select="@external_comment"/><xsl:if test="not(position()=last())"><xsl:text>
        </xsl:text></xsl:if></xsl:template>
	<xsl:template match="code:types/code:type" mode="size">
		<xsl:variable name="test">
			<xsl:call-template name="unique">
				<xsl:with-param name="name" select="@external_name"/>
			</xsl:call-template>
    </xsl:variable>
		<xsl:if test="not($test='')">
			<xsl:variable name="name" select="$test"/>
<xsl:call-template name="MAJ">
				<xsl:with-param name="text" select="$name"/>
			</xsl:call-template> (<xsl:value-of select="@data_size"/>)<xsl:if test="not(position()=last())">,</xsl:if><xsl:if test="position()=last()">;</xsl:if><xsl:text>
        </xsl:text></xsl:if>
	</xsl:template>
	<xsl:template match="code:types/code:type" mode="function">
    <xsl:variable name="external_name">
      <xsl:call-template name="normalize">
        <xsl:with-param name="name" select="@external_name"/>
      </xsl:call-template>
    </xsl:variable>
    public static void <xsl:call-template name="replace">
			<xsl:with-param name="name" select="$external_name"/>
		</xsl:call-template>(final float intensity, final Pointer data){
      // Your code
    }</xsl:template>
	<xsl:template match="code:types/code:type" mode="functionMultiplexer">
		<xsl:variable name="test">
			<xsl:call-template name="unique">
				<xsl:with-param name="name" select="@external_name"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:if test="not($test='')">
    public static void <xsl:call-template name="replace">
				<xsl:with-param name="name" select="$test"/>
			</xsl:call-template>(final float intensity, final Pointer data){
      // Your code
    }</xsl:if>
	</xsl:template>
	<xsl:template match="code:types/code:type" mode="callback">
    <xsl:variable name="external_name">
      <xsl:call-template name="normalize">
        <xsl:with-param name="name" select="@external_name"/>
      </xsl:call-template>
    </xsl:variable>
		<xsl:if test="not(position()=1)">,
        </xsl:if>new NomoInterpreter.NomoCallback() { public void invoke( float intensity,  Pointer  data) { <xsl:call-template name="replace">
			<xsl:with-param name="name" select="$external_name"/>
		</xsl:call-template>(intensity, data); } }
	</xsl:template>
	<xsl:template match="code:types/code:type" mode="callbackMultiplexer">
		<xsl:variable name="test">
			<xsl:call-template name="unique">
				<xsl:with-param name="name" select="@external_name"/>
			</xsl:call-template>
    </xsl:variable>
		<xsl:if test="not($test='')"><xsl:if test="not(position()=1)">,
        </xsl:if>new NomoInterpreter.NomoCallback() { public void invoke( float intensity,  Pointer  data) { <xsl:call-template name="replace">
				<xsl:with-param name="name" select="$test"/>
			</xsl:call-template>(intensity, data); } }</xsl:if>
	</xsl:template>
	<xsl:template name="MAJ">
		<xsl:param name="text"/>
		<xsl:value-of select="translate($text,'azertyuiopqsdfghjklmwxcvbn', 'AZERTYUIOPQSDFGHJKLMWXCVBN')"/>
	</xsl:template>
	<xsl:template name="min">
		<xsl:param name="text"/>
		<xsl:value-of select="translate($text,'AZERTYUIOPQSDFGHJKLMWXCVBN', 'azertyuiopqsdfghjklmwxcvbn')"/>
	</xsl:template>
	<xsl:template name="replace">
		<xsl:param name="name"/>
		<xsl:choose>
			<xsl:when test="contains($name,'_')">
				<xsl:variable name="name1" select="substring-before($name,'_')"/>
				<xsl:variable name="name2" select="substring-after($name,'_')"/>
				<xsl:variable name="name3">
					<xsl:call-template name="MAJ">
						<xsl:with-param name="text" select="substring($name2,1,1)"/>
					</xsl:call-template>
					<xsl:value-of select="substring($name2,2,string-length($name2))"/>
				</xsl:variable>
				<xsl:call-template name="replace">
					<xsl:with-param name="name" select="concat($name1, $name3)"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$name"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="components">
		<xsl:param name="name"/>
		<xsl:param name="result"/>
		<xsl:choose>
			<xsl:when test="contains($name,' ')">
				<xsl:variable name="name1" select="substring-before($name,' ')"/>
				<xsl:variable name="name2" select="substring-after($name,' ')"/>
				<xsl:call-template name="components">
					<xsl:with-param name="name" select="$name2"/>
					<xsl:with-param name="result" select="concat($result, $name1,', ')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat($result, $name)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="unique">
		<xsl:param name="name" select="@external_name"/>
		<xsl:choose>
			<xsl:when test="not(contains($name,'-'))">
				<xsl:value-of select="$name"/>
			</xsl:when>
			<xsl:when test="contains($name,'-1') and substring-after($name,'-1')=''">
				<xsl:value-of select="substring($name,1,string-length($name) - 2)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="''"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="normalize">
		<xsl:param name="name"/>
		<xsl:choose>
			<xsl:when test="contains($name,'-')">
        <xsl:value-of select="substring-before($name,'-')"/>
        <xsl:value-of select="'_'"/>
        <xsl:value-of select="substring-after($name,'-')"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$name"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
