<?xml version="1.0" encoding="utf-8" standalone="yes"?>
<!--
  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see <http://www.gnu.org/licenses/>
-->

<!--
Génére une interface en langage Ada pour une unité nomo donnée.
-->
<xsl:stylesheet version="1.0" xmlns:code="http://www.nomoseed.org/code" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:output method="text" encoding="utf-8"/>
	<xsl:variable name="unit">
		<xsl:call-template name="mixCase">
			<xsl:with-param name="oldname" select="/code:code/@unit"/>
		</xsl:call-template>
	</xsl:variable>
	<xsl:template match="code:code">--  Interface for nomoInterpreter created with nomoSDK
with System;
with Nomo_Interpreter;

package <xsl:value-of select="$unit"/> is

    use Nomo_Interpreter;

    <xsl:if test="code:types/code:type[@category='input']">
    --  ID of input types
    type Input_ID is (<xsl:apply-templates select="code:types/code:type[@category='input']" mode="type"/>
    for Input_ID use (<xsl:apply-templates select="code:types/code:type[@category='input']" mode="foruse"/>
    pragma Convention (C, Input_ID);

</xsl:if>    --  Size of inputs and commands
    <xsl:apply-templates select="code:types/code:type[@data_size]" mode="size"/>
   --  Components of inputs and components of commands<xsl:if test="/code:code/@multiplexer = 'yes'"> with demultiplexing value</xsl:if>
		<xsl:apply-templates select="code:types/code:type[@components]" mode="component"/>
   --  Command functions<xsl:if test="/code:code/@multiplexer = 'yes'"> with demultiplexing</xsl:if>
		<xsl:choose>
			<xsl:when test="/code:code/@multiplexer = 'yes'">
				<xsl:apply-templates select="code:types/code:type[@category='command']" mode="functionMultiplexer"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="code:types/code:type[@category='command']" mode="function"/>
			</xsl:otherwise>
		</xsl:choose>
    Actions : constant Callbacks (1..<xsl:choose>
			<xsl:when test="/code:code/@multiplexer = 'yes'">
				<xsl:value-of select="count(//code:type[@category='command' and (not(contains(@external_name, '-')) or (contains(@external_name,'-1') and substring-after(@external_name,'-1')=''))])"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="count(//code:type[@category='command'])"/>
			</xsl:otherwise>
		</xsl:choose>) := (<xsl:choose>
			<xsl:when test="/code:code/@multiplexer = 'yes'">
				<xsl:apply-templates select="code:types/code:type[@category='command']" mode="callbackMultiplexer"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="code:types/code:type[@category='command']" mode="callback"/>
			</xsl:otherwise>
		</xsl:choose>);

    --  ID of log types
    type Log_ID is (<xsl:apply-templates select="code:types/code:type[@category!='input']" mode="type"/>
    for Log_ID use (<xsl:apply-templates select="code:types/code:type[@category!='input']" mode="foruse"/>
    pragma Convention (C, Log_ID);

    type Log_flags is array (Log_ID) of Log_Flag;
    No_Log_Flags : constant Log_Flags := (others => No_Log);

end <xsl:value-of select="$unit"/>;</xsl:template>
	<xsl:template match="code:types/code:type[@category='input']" mode="type">
    <xsl:variable name="external_name">
      <xsl:call-template name="normalize">
				<xsl:with-param name="name" select="@external_name"/>
			</xsl:call-template>
    </xsl:variable>
    <xsl:variable name="name">
      <xsl:call-template name="mixCase">
        <xsl:with-param name="oldname" select="substring-after($external_name,'_')"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:value-of select="$name"/>
		<xsl:if test="not(position()=last())">,  --  <xsl:value-of select="@external_comment"/><xsl:text>
                      </xsl:text>
		</xsl:if>
		<xsl:if test="position()=last()"><xsl:text>);</xsl:text>  --  <xsl:value-of select="@external_comment"/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="code:types/code:type[@category='input']" mode="foruse">
    <xsl:variable name="external_name">
      <xsl:call-template name="normalize">
				<xsl:with-param name="name" select="@external_name"/>
			</xsl:call-template>
		</xsl:variable>
    <xsl:variable name="name">
      <xsl:call-template name="mixCase">
        <xsl:with-param name="oldname" select="substring-after($external_name,'_')"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:value-of select="$name"/> => <xsl:value-of select="@id"/>
		<xsl:if test="not(position()=last())">,
                      </xsl:if>
		<xsl:if test="position()=last()">
			<xsl:text>);</xsl:text>
		</xsl:if>
	</xsl:template>
	<xsl:template match="code:types/code:type" mode="size">
		<xsl:variable name="test">
			<xsl:call-template name="unique">
				<xsl:with-param name="name" select="@external_name"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:if test="not($test='')">
			<xsl:variable name="name">
				<xsl:call-template name="mixCase">
					<xsl:with-param name="oldname" select="$test"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:value-of select="$name"/>_Size : constant := <xsl:value-of select="@data_size"/>;
    </xsl:if>
	</xsl:template>
	<xsl:template match="code:types/code:type[@components]" mode="component">
		<xsl:variable name="test">
			<xsl:call-template name="unique">
				<xsl:with-param name="name" select="@external_name"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:if test="not($test='')">
		<xsl:variable name="enum">
			<xsl:call-template name="mixCase">
				<xsl:with-param name="oldname" select="$test"/>
			</xsl:call-template>
		</xsl:variable>
    type <xsl:value-of select="concat($enum, '_Component')"/> is (<xsl:call-template name="components_type">
			<xsl:with-param name="name" select="@components"/>
			<xsl:with-param name="result" select="''"/>
		</xsl:call-template>
		<xsl:if test="@category='command' and /code:code/@multiplexer = 'yes'">, Id</xsl:if>);
    for <xsl:value-of select="concat($enum, '_Component')"/> use (<xsl:call-template name="components_foruse">
			<xsl:with-param name="name" select="@components"/>
			<xsl:with-param name="result" select="''"/>
			<xsl:with-param name="number" select="0"/>
		</xsl:call-template>
		<xsl:if test="@category='command' and /code:code/@multiplexer = 'yes'">, Id => <xsl:value-of select="@data_size - 1"/>
		</xsl:if>);
    pragma Convention (C, <xsl:value-of select="concat($enum, '_Component')"/>);
    type <xsl:value-of select="concat($enum, '_Data')"/> is array (<xsl:value-of select="concat($enum, '_Component')"/>) of Nomo_Interpreter.Real;
    pragma Convention (C, <xsl:value-of select="concat($enum, '_Data')"/>);
</xsl:if>
</xsl:template>
	<xsl:template match="code:types/code:type[@category!='input']" mode="type">
    <xsl:variable name="external_name">
      <xsl:call-template name="normalize">
				<xsl:with-param name="name" select="@external_name"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:call-template name="mixCase">
			<xsl:with-param name="oldname" select="$external_name"/>
		</xsl:call-template>
		<xsl:if test="not(position()=last())">,  --  <xsl:value-of select="@external_comment"/><xsl:text>
                    </xsl:text>
		</xsl:if>
		<xsl:if test="position()=last()"><xsl:text>);</xsl:text>  --  <xsl:value-of select="@external_comment"/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="code:types/code:type[@category!='input']" mode="foruse">
    <xsl:variable name="external_name">
      <xsl:call-template name="normalize">
				<xsl:with-param name="name" select="@external_name"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:call-template name="mixCase">
			<xsl:with-param name="oldname" select="$external_name"/>
		</xsl:call-template> => <xsl:value-of select="@id - count(//code:type[@category='input']) - 1"/>
		<xsl:if test="not(position()=last())">,
                    </xsl:if>
		<xsl:if test="position()=last()">
			<xsl:text>);</xsl:text>
		</xsl:if>
	</xsl:template>
	<xsl:template match="code:types/code:type" mode="function">
    <xsl:variable name="external_name">
      <xsl:call-template name="normalize">
				<xsl:with-param name="name" select="@external_name"/>
			</xsl:call-template>
    </xsl:variable>
		<xsl:variable name="name">
			<xsl:call-template name="mixCase">
				<xsl:with-param name="oldname" select="$external_name"/>
			</xsl:call-template>
		</xsl:variable>
    procedure <xsl:value-of select="$name"/> (Intensity : in Real_0_To_1; Data : in System.Address);
    pragma Convention (C, <xsl:value-of select="$name"/>);
</xsl:template>
	<xsl:template match="code:types/code:type" mode="functionMultiplexer">
		<xsl:variable name="test">
			<xsl:call-template name="unique">
				<xsl:with-param name="name" select="@external_name"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:if test="not($test='')">
			<xsl:variable name="name">
				<xsl:call-template name="mixCase">
					<xsl:with-param name="oldname" select="$test"/>
				</xsl:call-template>
			</xsl:variable>
    procedure <xsl:value-of select="$name"/> (Intensity : in Real_0_To_1; Data : in System.Address);
    pragma Convention (C, <xsl:value-of select="$name"/>);
</xsl:if>
	</xsl:template>
	<xsl:template match="code:types/code:type" mode="callback">
		<xsl:if test="@id != //code:types/code:type[@category='command'][1]/@id">,
                                            </xsl:if><xsl:value-of select="position()"/> => <xsl:call-template name="mixCase">
			<xsl:with-param name="oldname" select="@external_name"/>
		</xsl:call-template>'Access</xsl:template>
	<xsl:template match="code:types/code:type" mode="callbackMultiplexer">
		<xsl:variable name="test">
			<xsl:call-template name="unique">
				<xsl:with-param name="name" select="@external_name"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:if test="not($test='')">
			<xsl:if test="@id != //code:types/code:type[@category='command'][1]/@id">,
                                            </xsl:if><xsl:value-of select="position()"/> => <xsl:call-template name="mixCase">
				<xsl:with-param name="oldname" select="$test"/>
			</xsl:call-template>
			<xsl:text>'Access</xsl:text>
		</xsl:if>
	</xsl:template>
	<xsl:template name="MAJ">
		<xsl:param name="text"/>
		<xsl:value-of select="translate($text,'azertyuiopqsdfghjklmwxcvbn', 'AZERTYUIOPQSDFGHJKLMWXCVBN')"/>
	</xsl:template>
	<xsl:template name="min">
		<xsl:param name="text"/>
		<xsl:value-of select="translate($text,'AZERTYUIOPQSDFGHJKLMWXCVBN', 'azertyuiopqsdfghjklmwxcvbn')"/>
	</xsl:template>
	<xsl:template name="components_type">
		<xsl:param name="name"/>
		<xsl:param name="result"/>
		<xsl:choose>
			<xsl:when test="contains($name,' ')">
				<xsl:variable name="name1" select="substring-before($name,' ')"/>
				<xsl:variable name="name2">
					<xsl:call-template name="MAJ">
						<xsl:with-param name="text" select="substring($name1,1,1)"/>
					</xsl:call-template>
					<xsl:call-template name="min">
						<xsl:with-param name="text" select="substring($name1,2,string-length($name1))"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="name3" select="substring-after($name,' ')"/>
				<xsl:call-template name="components_type">
					<xsl:with-param name="name" select="$name3"/>
					<xsl:with-param name="result" select="concat($result, $name2, ', ')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="name1">
					<xsl:call-template name="MAJ">
						<xsl:with-param name="text" select="substring($name,1,1)"/>
					</xsl:call-template>
					<xsl:call-template name="min">
						<xsl:with-param name="text" select="substring($name,2,string-length($name))"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat($result, $name1)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="components_foruse">
		<xsl:param name="name"/>
		<xsl:param name="result"/>
		<xsl:param name="number"/>
		<xsl:choose>
			<xsl:when test="contains($name,' ')">
				<xsl:variable name="name1" select="substring-before($name,' ')"/>
				<xsl:variable name="name2">
					<xsl:call-template name="MAJ">
						<xsl:with-param name="text" select="substring($name1,1,1)"/>
					</xsl:call-template>
					<xsl:call-template name="min">
						<xsl:with-param name="text" select="substring($name1,2,string-length($name1))"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="name3" select="substring-after($name,' ')"/>
				<xsl:call-template name="components_foruse">
					<xsl:with-param name="name" select="$name3"/>
					<xsl:with-param name="result" select="concat($result, $name2,' =&gt; ', $number, ', ')"/>
					<xsl:with-param name="number" select="$number + 1"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="name1">
					<xsl:call-template name="MAJ">
						<xsl:with-param name="text" select="substring($name,1,1)"/>
					</xsl:call-template>
					<xsl:call-template name="min">
						<xsl:with-param name="text" select="substring($name,2,string-length($name))"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat($result, $name1,' =&gt; ', $number)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="mixCase">
		<xsl:param name="newname" select="''"/>
		<xsl:param name="oldname"/>
		<xsl:choose>
			<xsl:when test="$oldname">
				<xsl:variable name="name1">
					<xsl:choose>
						<xsl:when test="contains($oldname,'_')">
							<xsl:value-of select="substring-before($oldname,'_')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$oldname"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:variable name="name2">
					<xsl:call-template name="MAJ">
						<xsl:with-param name="text" select="substring($name1, 1 ,1)"/>
					</xsl:call-template>
					<xsl:call-template name="min">
						<xsl:with-param name="text" select="substring($name1, 2, string-length($name1))"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="mixCase">
					<xsl:with-param name="newname" select="concat($newname, $name2,  '_')"/>
					<xsl:with-param name="oldname" select="substring-after($oldname,'_')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="substring($newname,1,string-length($newname)-1)"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="unique">
		<xsl:param name="name" select="@external_name"/>
		<xsl:choose>
			<xsl:when test="not(contains($name,'-'))">
				<xsl:value-of select="$name"/>
			</xsl:when>
			<xsl:when test="contains($name,'-1') and substring-after($name,'-1')=''">
				<xsl:value-of select="substring($name,1,string-length($name) - 2)"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="''"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="normalize">
		<xsl:param name="name"/>
		<xsl:choose>
			<xsl:when test="contains($name,'-')">
        <xsl:value-of select="substring-before($name,'-')"/>
        <xsl:value-of select="'_'"/>
        <xsl:value-of select="substring-after($name,'-')"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$name"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
