<?xml version="1.0" encoding="utf-8" standalone="yes"?>
<!--
  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see <http://www.gnu.org/licenses/>
-->

<!--
Deuxième étape de l'encodage :
  - Numéroter les types pour chaque catégorie
  - Numéroter les items de chaque type
  - Numéroter les instances des sous-programmes
  - Ajouter les attributs 'hue', 'saturation' et 'luminance' aux éléments 'declaration'
  - Ajouter les attributs 'program' et 'model' aux éléments 'model'
  - Eliminer la base des modèles.
  - Eliminer l'élément sdk.
-->

<xsl:stylesheet version="1.0" xmlns:program="http://www.nomoseed.org/program" xmlns:sdk="http://www.nomoseed.org/sdk" xmlns:model="http://www.nomoseed.org/model" xmlns:plant="http://www.nomoseed.org/plant" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:code="http://www.nomoseed.org/code" xmlns:project="http://www.nomoseed.org/project" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:output method="xml" standalone="no" indent="no" encoding="utf-8"/>
	<xsl:variable name="colors" select="document('../categories_colors.xml')/categories_colors/category_color"/>
	<xsl:template match="code:code">
		<xsl:copy>
			<xsl:attribute name="unit">
				<xsl:value-of select="@unit"/>
			</xsl:attribute>
			<xsl:attribute name="multiplexer">
				<xsl:value-of select="@multiplexer"/>
			</xsl:attribute>
			<xsl:attribute name="binaryLocation">
				<xsl:value-of select="@binaryLocation"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="*">
		<xsl:copy-of select="."/>
	</xsl:template>
	<xsl:template match="program:models/program:new | program:models/program:inherite">
		<xsl:copy>
			<xsl:attribute name="instance">
				<xsl:value-of select="@instance"/>
			</xsl:attribute>
			<xsl:attribute name="model">
				<xsl:value-of select="@model"/>
			</xsl:attribute>
			<xsl:attribute name="prototype">
				<xsl:value-of select="@prototype"/>
			</xsl:attribute>
			<xsl:variable name="prototype" select="@prototype"/>
			<xsl:attribute name="number">
				<xsl:number level="any" count="program:models/program:new[@prototype=$prototype] | program:models/program:inherite[@prototype=$prototype]"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="model:model">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:attribute name="xml:base">
				<xsl:value-of select="@xml:base"/>
			</xsl:attribute>
			<xsl:attribute name="xsi:schemaLocation">
				<xsl:value-of select="@xsi:schemaLocation"/>
			</xsl:attribute>
			<xsl:attribute name="model">
				<xsl:for-each select=".//model:definition[@base != '*']">
					<xsl:value-of select="@base"/>
						<xsl:value-of select="' '"/>
				</xsl:for-each>
        <xsl:value-of select="concat(parent::program:*/@prototype, ':', parent::program:*/@instance)"/>
			</xsl:attribute>
				<xsl:attribute name="program">
          <xsl:value-of select="ancestor::program:program[position() = last()]/@name"/>
					<xsl:for-each select="ancestor::program:program[../@instance]">
              <xsl:value-of select="' '"/>
              <xsl:value-of select="@name"/>
							<xsl:value-of select="concat (':', ../@instance)"/>
					</xsl:for-each>
				</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="model:declaration">
		<xsl:variable name="type" select="@type"/>
		<xsl:variable name="category" select="@category"/>
		<xsl:variable name="model" select="@model"/>
		<xsl:copy>
			<xsl:attribute name="type">
				<xsl:value-of select="@type"/>
			</xsl:attribute>
			<xsl:attribute name="category">
				<xsl:value-of select="@category"/>
			</xsl:attribute>
			<xsl:attribute name="model">
				<xsl:value-of select="@model"/>
			</xsl:attribute>
			<xsl:attribute name="id">
				<xsl:number level="any" count="model:declaration[@category=$category and not(ancestor::model:base) and (ancestor::program:new or ancestor::program:inherite)]"/>
			</xsl:attribute>
			<xsl:choose>
				<xsl:when test="ancestor::program:program/program:sdk/sdk:color[@category=$category and @model=$model and @type=$type]">
					<xsl:variable name="color" select="ancestor::program:program/program:sdk/sdk:color[@category=$category and @model=$model and @type=$type]"/>
					<xsl:attribute name="hue">
						<xsl:value-of select="$color/@hue"/>
					</xsl:attribute>
					<xsl:attribute name="saturation">
						<xsl:value-of select="$color/@saturation"/>
					</xsl:attribute>
					<xsl:attribute name="luminance">
						<xsl:value-of select="$color/@luminance"/>
					</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="hue">
						<xsl:value-of select="$colors[@name=$category]/@hue"/>
					</xsl:attribute>
					<xsl:attribute name="saturation">
						<xsl:value-of select="$colors[@name=$category]/@saturation"/>
					</xsl:attribute>
					<xsl:attribute name="luminance">
						<xsl:value-of select="$colors[@name=$category]/@luminance"/>
					</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="plant:declaration">
		<xsl:variable name="category" select="@category"/>
		<xsl:variable name="type" select="@type"/>
		<xsl:variable name="model" select="@model"/>
		<xsl:copy>
			<xsl:attribute name="type">
				<xsl:value-of select="@type"/>
			</xsl:attribute>
			<xsl:attribute name="category">
				<xsl:value-of select="@category"/>
			</xsl:attribute>
			<xsl:attribute name="model">
				<xsl:value-of select="@model"/>
			</xsl:attribute>
			<xsl:choose>
				<xsl:when test="ancestor::program:program/program:sdk/sdk:color[@category=$category and @model=$model and @type=$type]">
					<xsl:variable name="color" select="ancestor::program:program/program:sdk/sdk:color[@category=$category and @model=$model and @type=$type]"/>
					<xsl:attribute name="hue">
						<xsl:value-of select="$color/@hue"/>
					</xsl:attribute>
					<xsl:attribute name="saturation">
						<xsl:value-of select="$color/@saturation"/>
					</xsl:attribute>
					<xsl:attribute name="luminance">
						<xsl:value-of select="$color/@luminance"/>
					</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="hue">
						<xsl:value-of select="$colors[@name=$category]/@hue"/>
					</xsl:attribute>
					<xsl:attribute name="saturation">
						<xsl:value-of select="$colors[@name=$category]/@saturation"/>
					</xsl:attribute>
					<xsl:attribute name="luminance">
						<xsl:value-of select="$colors[@name=$category]/@luminance"/>
					</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:attribute name="id">
				<xsl:number level="any" count="plant:declaration[@category=$category]" from="//plant:plant_structure"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="model:predictive_structure">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:attribute name="target">
				<xsl:value-of select="@target"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="model:definition/model:*/model:items/model:item">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:attribute name="model">
				<xsl:value-of select="@model"/>
			</xsl:attribute>
			<xsl:attribute name="type">
				<xsl:value-of select="@type"/>
			</xsl:attribute>
			<xsl:attribute name="id">
				<xsl:number level="single" count="model:item"/>
			</xsl:attribute>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="model:item"/>
	<xsl:template match="plant:item[ancestor::plant:transition_type or ancestor::plant:anomaly_type]">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:attribute name="model">
				<xsl:value-of select="@model"/>
			</xsl:attribute>
			<xsl:attribute name="type">
				<xsl:value-of select="../../plant:declaration/@type"/>
			</xsl:attribute>
			<xsl:attribute name="id">
				<xsl:number level="single" count="plant:item"/>
			</xsl:attribute>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="plant:item[./plant:target and ancestor::plant:input]">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:attribute name="model">
				<xsl:value-of select="@model"/>
			</xsl:attribute>
      <xsl:attribute name="base">
        <xsl:value-of select="@base"/>
      </xsl:attribute>
			<xsl:attribute name="id">
				<xsl:number level="any" count="plant:item[./plant:target and ancestor::plant:input and not(ancestor::model:base)]"/>
			</xsl:attribute>
      <xsl:copy-of select="*"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="plant:item[./plant:target and ancestor::plant:other]">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:attribute name="model">
				<xsl:value-of select="@model"/>
			</xsl:attribute>
      <xsl:attribute name="base">
        <xsl:value-of select="@base"/>
      </xsl:attribute>
			<xsl:attribute name="id">
				<xsl:number level="any" count="plant:item[./plant:target and ancestor::plant:other and not(ancestor::model:base)]"/>
			</xsl:attribute>
      <xsl:copy-of select="*"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="plant:item[not(./plant:target) and ancestor::plant:input]">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:attribute name="model">
				<xsl:value-of select="@model"/>
			</xsl:attribute>
      <xsl:attribute name="base">
        <xsl:value-of select="@base"/>
      </xsl:attribute>
			<xsl:attribute name="id">
				<xsl:number level="any" count="plant:item[not(./plant:target) and ancestor::plant:input and not(ancestor::model:base)]"/>
			</xsl:attribute>
      <xsl:copy-of select="*"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="plant:item[not(./plant:target) and ancestor::plant:other]">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:attribute name="model">
				<xsl:value-of select="@model"/>
			</xsl:attribute>
      <xsl:attribute name="base">
        <xsl:value-of select="@base"/>
      </xsl:attribute>
			<xsl:attribute name="id">
				<xsl:number level="any" count="plant:item[not(./plant:target) and ancestor::plant:other and not(ancestor::model:base)]"/>
			</xsl:attribute>
      <xsl:copy-of select="*"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:program | plant:plant_structure | model:plant_structure | plant:anomaly_type | plant:transition_type | model:perceptive_structure | model:conception_type | model:command_type | model:reward_type | model:landmark_type">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:programs | program:body | program:models | plant:items | plant:definition | plant:declarations | model:items | model:definition | model:declarations | plant:registers_structure | plant:input | plant:scope_type | plant:operator_type | plant:other| plant:premise | plant:conclusion">
		<xsl:copy>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:programs/program:new | program:programs/program:inherite">
		<xsl:copy>
			<xsl:attribute name="instance">
				<xsl:value-of select="@instance"/>
			</xsl:attribute>
			<xsl:variable name="name" select="./program:program/@name"/>
			<xsl:attribute name="number">
				<xsl:number level="any" count="program:program[@name=$name]"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="project:*"/>
	<xsl:template match="model:base"/>
	<xsl:template match="program:sdk"/>
</xsl:stylesheet>
