<?xml version="1.0" encoding="utf-8" standalone="yes"?>
<!--
  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see <http://www.gnu.org/licenses/>
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:ws="http://www.nomoseed.org/worldsquare">
	<xsl:output method="xml" standalone="no" indent="no" encoding="utf-8"/>
	<xsl:key name="slabKey" match="ws:slab" use="@id"/>
	<xsl:template match="ws:worldsquare">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:apply-templates select="ws:slab"/>
			<xsl:for-each select="ws:agent[ws:depose]">
				<xsl:if test="ws:sphere/@number &gt; 0">
					<xsl:variable name="on" select="@on"/>
					<xsl:if test="not (ws:sphere[@on=$on])">
						<xsl:element name="sphere" namespace="http://www.nomoseed.org/worldsquare">
							<xsl:attribute name="on">
								<xsl:value-of select="$on"/>
							</xsl:attribute>
						</xsl:element>
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
			<xsl:apply-templates select="ws:sphere | ws:agent | ws:sum_sounds"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="ws:advance" mode="success">
		<xsl:copy>
			<xsl:attribute name="old_on">
				<xsl:value-of select="../@on"/>
			</xsl:attribute>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="ws:advance" mode="failed">
		<xsl:copy/>
              <xsl:element name="strength" namespace="http://www.nomoseed.org/worldsquare"/>
	</xsl:template>
	<xsl:template match="ws:capture | ws:depose">
		<xsl:copy/>
	</xsl:template>
	<xsl:template match="ws:turn_right | ws:turn_left">
		<xsl:copy>
			<xsl:attribute name="old_direction">
				<xsl:value-of select="../@direction"/>
			</xsl:attribute>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="ws:agent">
		<xsl:variable name="slab_current" select="key('slabKey',@on)"/>
		<xsl:copy>
			<xsl:if test="not (ws:advance)">
				<xsl:attribute name="on">
					<xsl:value-of select="@on"/>
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="not (ws:turn_right | ws:turn_left)">
				<xsl:attribute name="direction">
					<xsl:value-of select="@direction"/>
				</xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="ws:depose | ws:capture"/>
			<xsl:choose>
				<xsl:when test="ws:advance">
					<xsl:variable name="x" select="$slab_current/@x"/>
					<xsl:variable name="y" select="$slab_current/@y"/>
					<xsl:choose>
						<xsl:when test="@direction=0">
							<xsl:variable name="on_0" select="/ws:worldsquare/ws:slab[@x = $x and @y = $y - 1]"/>
							<xsl:choose>
								<xsl:when test="$on_0 and not(/ws:worldsquare//ws:agent[@on = $on_0/@id])">
									<xsl:attribute name="on">
										<xsl:value-of select="$on_0/@id"/>
									</xsl:attribute>
									<xsl:apply-templates select="ws:advance" mode="success"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="on">
										<xsl:value-of select="@on"/>
									</xsl:attribute>
									<xsl:apply-templates select="ws:advance" mode="failed"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:when test="@direction=90 mod 360">
							<xsl:variable name="on_90" select="/ws:worldsquare/ws:slab[@x=$x + 1 and @y=$y]"/>
							<xsl:choose>
								<xsl:when test="$on_90 and not(/ws:worldsquare//ws:agent[@on = $on_90/@id])">
									<xsl:attribute name="on">
										<xsl:value-of select="$on_90/@id"/>
									</xsl:attribute>
									<xsl:apply-templates select="ws:advance" mode="success"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="on">
										<xsl:value-of select="@on"/>
									</xsl:attribute>
									<xsl:apply-templates select="ws:advance" mode="failed"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:when test="@direction=180">
							<xsl:variable name="on_180" select="/ws:worldsquare/ws:slab[@x = $x and @y = $y + 1]"/>
							<xsl:choose>
								<xsl:when test="$on_180 and not(/ws:worldsquare//ws:agent[@on = $on_180/@id])">
									<xsl:attribute name="on">
										<xsl:value-of select="$on_180/@id"/>
									</xsl:attribute>
									<xsl:apply-templates select="ws:advance" mode="success"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="on">
										<xsl:value-of select="@on"/>
									</xsl:attribute>
									<xsl:apply-templates select="ws:advance" mode="failed"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:when test="@direction=270">
							<xsl:variable name="on_270" select="/ws:worldsquare/ws:slab[@x = $x - 1 and @y = $y]"/>
							<xsl:choose>
								<xsl:when test="$on_270 and not(/ws:worldsquare//ws:agent[@on = $on_270/@id])">
									<xsl:attribute name="on">
										<xsl:value-of select="$on_270/@id"/>
									</xsl:attribute>
									<xsl:apply-templates select="ws:advance" mode="success"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="on">
										<xsl:value-of select="@on"/>
									</xsl:attribute>
									<xsl:apply-templates select="ws:advance" mode="failed"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
				<xsl:when test="ws:turn_right">
					<xsl:attribute name="direction">
						<xsl:value-of select="(@direction + 90) mod 360"/>
					</xsl:attribute>
					<xsl:apply-templates select="ws:turn_right"/>
				</xsl:when>
				<xsl:when test="ws:turn_left">
					<xsl:attribute name="direction">
						<xsl:value-of select="(360 + @direction - 90) mod 360"/>
					</xsl:attribute>
					<xsl:apply-templates select="ws:turn_left"/>
				</xsl:when>
				<xsl:when test="ws:capture">
					<xsl:variable name="on" select="@on"/>
					<xsl:choose>
						<xsl:when test="/ws:worldsquare/ws:sphere[@on=$on]">
							<xsl:apply-templates select="ws:sphere" mode="capture"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:apply-templates select="ws:sphere" mode="failed"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:when test="ws:depose">
					<xsl:variable name="on" select="@on"/>
					<xsl:choose>
						<xsl:when test="not (/ws:worldsquare/ws:sphere[@on=$on]) and (ws:sphere/@number &gt; 0)">
							<xsl:apply-templates select="ws:sphere" mode="depose"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:apply-templates select="ws:sphere" mode="failed"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
			<xsl:if test="not (ws:depose | ws:capture)">
				<xsl:apply-templates select="ws:sphere"/>
			</xsl:if>
			<xsl:apply-templates select="ws:sonar | ws:bumper | ws:hue "/>
			<xsl:apply-templates select="ws:sound"/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="ws:sphere" mode="capture">
		<xsl:copy>
			<xsl:attribute name="number">
				<xsl:value-of select="@number + 1"/>
			</xsl:attribute>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="ws:sphere" mode="depose">
		<xsl:copy>
			<xsl:attribute name="number">
				<xsl:value-of select="@number - 1"/>
			</xsl:attribute>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="ws:sphere" mode="failed">
		<xsl:copy-of select="."/>
              <xsl:element name="strength" namespace="http://www.nomoseed.org/worldsquare"/>
	</xsl:template>
	<xsl:template match="ws:slab | ws:sum_sounds | ws:sonar | ws:bumper | ws:hue | ws:sound | ws:sphere">
		<xsl:copy-of select="."/>
	</xsl:template>
	<xsl:template match="ws:sphere">
		<xsl:variable name="on" select="@on"/>
		<xsl:if test="not (//ws:agent[@on=$on]/ws:capture)">
			<xsl:copy-of select="."/>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
