//  Copyright (2010-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published
//  by the Free Software Foundation, version 2 of the License.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program. If not, see <http://www.gnu.org/licenses/>

var view;

function mouseWheel_View (evt)
{
    view.scale(evt.clientX, evt.clientY, 1 + (evt.wheelDelta / 3600)*2);
}

function mouseDown_View (evt)
{
  if (evt.button == 0 && !evt.ctrlKey)
    view.setTranslationOrigin(evt.clientX, evt.clientY);
}

function mouseUp_View (evt)
{
  if (evt.button == 0)
  {
    view.stopTranslation();
    evt.stopPropagation();
  }
}

function dblClick_View (evt)
{
  if (evt.button == 0)
  {
    view.resize();
    evt.stopPropagation();
  }
}

function mouseOut_View(evt)
{
	if (evt.relatedTarget.toString().search("SVG") == -1)
		view.stopTranslation();
}

function mouseMove_View (evt)
{
    view.translate(evt.clientX, evt.clientY);
}

function viewControl (graph)
{
  var height_box;
  var height_svg;
  var box;
  var obox;
  var dx;
  var ox;
  var oy;
  var oldx;
  var oldy;
  var zoom;
  graph.addEventListener("mouseout", mouseOut_View, false);
  graph.addEventListener("mousedown", mouseDown_View, false);
  window.addEventListener("mousewheel", mouseWheel_View, false);
  graph.addEventListener("dblclick", dblClick_View, false);
  
  this.initialize = function(){
    obox = graph.getAttribute("viewBox").split(',');
	box = obox;
    height_box = Number(box[3]);
	height_svg = Number(graph.style.height.split("px")[0]);
	dx= (window.innerWidth - height_svg)/2;
  }
 
  this.refresh = function(newGraph){
	graph = newGraph;
	graph.addEventListener("mouseout", mouseOut_View, false);
	graph.addEventListener("mousedown", mouseDown_View, false);
	graph.addEventListener("dblclick", dblClick_View, false);
  }
  
  this.scale = function (x, y, z)
  {
    box = graph.getAttribute("viewBox").split(',');
	var dz = box[3] * (1-z) / height_svg;
	var box3 = Number(box[3]) * z;
	zoom = height_svg / box3;
	var box2 = box3;
	var box1 = Number(box[1]) + (y * dz);
	var box0 = Number(box[0]) + (x - dx) * dz;
	var shift = (height_box - box3)/2
	if (height_box > box3 )
		if (box3 >= Number((height_box - box1)))
		{
			if (shift * zoom < height_box/1.33)//|| shift < box0)
				graph.setAttribute("viewBox", shift + "," + (height_box - box3) + "," + box2 + "," + box3);
			else
				graph.setAttribute("viewBox", box0 + "," + (height_box - box3 ) + "," + box2 + "," + box3);
		}
		else if (box1 < 0)
		{
			if (shift * zoom < height_box/1.33)//|| shift < box0)
				graph.setAttribute("viewBox", shift  + "," + box[1] + "," + box2 + "," + box3);
			else
				graph.setAttribute("viewBox", box0 + "," + box[1] + "," + box2 + "," + box3);
		}
		else
		{
			if (shift * zoom < height_box/1.33 )//|| shift < box0)
				graph.setAttribute("viewBox", shift + "," + box1 + "," + box2 + "," + box3);
			else
				graph.setAttribute("viewBox", box0 + "," + box1 + "," + box2 + "," + box3);
		}
	
  }
  
  this.setTranslationOrigin = function (x, y)
  {
    ox = x;
    oy = y;
	oldx = ox;
	oldy = oy;
    box = graph.getAttribute("viewBox").split(',');
    graph.addEventListener("mousemove", mouseMove_View, false);
    graph.addEventListener("mouseup", mouseUp_View, false);
	window.removeEventListener("mousewheel", mouseWheel_View, false);
	zoom = box[3] / height_svg;
  }
  
  this.translate = function (x, y)
  {
	var box1 = box[1]- (y-oy)*zoom;
	var box0 = box[0]- (x-ox)*zoom;
	var dxz = dx * zoom;
	if (box1 > 0 && box[3] < (height_box - box1) && box0 > dxz && box[3] < (height_box - box0)-dxz )
	{
		graph.setAttribute("viewBox", box0 + "," + box1 + "," + box[2] + "," + box[3]);
		oldx = x;
		oldy = y;
	}
	else if (box1>0 && box[3] < (height_box - box1)){
		graph.setAttribute("viewBox", (box[0]- (oldx-ox)*zoom) + "," + box1 + "," + box[2] + "," + box[3]);
		oldy = y;
	}
	else if (box0 > dxz && box[3] < (height_box - box0)-dxz)
	{
		graph.setAttribute("viewBox", box0 + "," + (box[1]- (oldy-oy)*zoom) + "," + box[2] + "," + box[3]);
		oldx = x;
	}
  }
  
  this.stopTranslation = function ()
  {
      graph.removeEventListener("mousemove", mouseMove_View, false);
      graph.removeEventListener("mouseup", mouseUp_View, false);
      window.addEventListener("mousewheel", mouseWheel_View, false);
  }
  
  this.resize = function(){
	graph.setAttribute("viewBox", obox);
  }
  
} 