<?xml version="1.0" encoding="UTF-8"?>
<program xmlns="http://www.nomoseed.org/program" name="exploration">
  <header xmlns="http://www.nomoseed.org/project">
    <author>Cédric Coussinet (cedric.coussinet@nomoseed.net)</author>
    <copyright>
      <mention xml:lang="en">
        Copyright (2013) Cédric Coussinet
      </mention>
    </copyright>
    <license name="GPLv3">
      <mention xml:lang="en">
        This program is free software: you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published
        by the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version.
        
        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
        GNU General Public License for more details.
        
        You should have received a copy of the GNU General Public License
        along with this program. If not, see http://www.gnu.org/licenses
      </mention>
    </license>
    <datetime>2014-07-05T08:51:52Z</datetime>
    <version/>
    <annotation>
      <documentation xml:lang="fr">
        Programme correspondant au exemple du tutoriel portant sur les propriétés élémentaires.
      </documentation>
    </annotation>
  </header>
  <subprograms xmlns:xi="http://www.w3.org/2001/XInclude">
    <new instance="exploration_automaton">
      <xi:include href="exploration_automaton.prg"/>
    </new>
    <inherite instance="body">
      <xi:include href="body.prg"/>
    </inherite>
  </subprograms>
  <body>
    <models xmlns:xi="http://www.w3.org/2001/XInclude">
      <import instance="body" subprogram="body">
        <xi:include href="body.mod" parse="xml"/>
      </import>
      <import instance="exploration_automaton" subprogram="exploration_automaton">
        <xi:include href="exploration_automaton.prg#xmlns(model=http://www.nomoseed.org/model)xpointer((//model:model[@name='exploration_automaton'])[1])"/>
      </import>
      <new instance="orientation">
        <xi:include href="orientation.mod" parse="xml"/>
      </new>
    </models>
    <scheme>
      <scheme name="advance">
        <rule name="front_advance_action">
          <premise model="exploration_automaton" category="conception" type="state">
            <information value="advance" tolerance="0"/>
            <credibility value="1" tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <conclusion model="body" category="conception" type="motor">
            <information value="advance"/>
          </conclusion>
        </rule>
        <rule name="advance_action">
          <premise model="exploration_automaton" category="conception" type="state">
            <information value="advance" tolerance="0"/>
            <credibility value="1" tolerance="INF"/>
            <timespan value="-1" tolerance="INF"/>
          </premise>
          <premise model="body" category="command" type="motor">
            <information value="advance" tolerance="0"/>
            <credibility value="1" tolerance="INF"/>
            <timespan value="1" tolerance="0"/>
          </premise>
          <premise model="body" category="perception" type="strength" inhibitor="true">
            <information value="failed" tolerance="INF"/>
            <credibility value="1" tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <conclusion model="body" category="conception" type="motor">
            <information value="advance"/>
          </conclusion>
        </rule>
      </scheme>
      <scheme name="turn">
        <scheme name="orientation">
          <rule name="initialize" relevance="0">
            <conclusion model="orientation" category="conception" type="orientation">
              <information value="right" delay="MAX"/>
            </conclusion>
          </rule>
          <rule name="set_right">
            <premise model="orientation" category="conception" type="orientation">
              <information value="right" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="0" tolerance="0"/>
            </premise>
            <conclusion model="orientation" category="conception" type="orientation">
              <information value="right" delay="MAX"/>
            </conclusion>
          </rule>
          <rule name="front_right">
            <premise model="orientation" category="conception" type="orientation">
              <information value="left" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="-1" tolerance="INF"/>
            </premise>
            <premise model="exploration_automaton" category="conception" type="event">
              <information value="line_beginning" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="0" tolerance="0"/>
            </premise>
            <conclusion model="orientation" category="conception" type="orientation">
              <information value="right"/>
            </conclusion>
          </rule>
          <rule name="set_left" relevance="1">
            <premise model="orientation" category="conception" type="orientation">
              <information value="left" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="0" tolerance="0"/>
            </premise>
            <conclusion model="orientation" category="conception" type="orientation">
              <information value="left" delay="MAX"/>
            </conclusion>
          </rule>
          <rule name="front_left">
            <premise model="orientation" category="conception" type="orientation">
              <information value="right" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="-1" tolerance="INF"/>
            </premise>
            <premise model="exploration_automaton" category="conception" type="event">
              <information value="line_beginning" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="0" tolerance="0"/>
            </premise>
            <conclusion model="orientation" category="conception" type="orientation">
              <information value="left"/>
            </conclusion>
          </rule>
        </scheme>
        <scheme name="left">
          <rule name="front_turn_action_left">
            <premise model="exploration_automaton" category="conception" type="state">
              <information value="turn" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="0" tolerance="0"/>
            </premise>
            <premise model="orientation" category="conception" type="orientation">
              <information value="left" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="-1" tolerance="INF"/>
            </premise>
            <conclusion model="body" category="conception" type="motor">
              <information value="turn_left"/>
            </conclusion>
          </rule>
          <rule name="turn_action_left">
            <premise model="exploration_automaton" category="conception" type="state">
              <information value="turn" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="-1" tolerance="INF"/>
            </premise>
            <premise model="orientation" category="conception" type="orientation">
              <information value="left" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="-1" tolerance="INF"/>
            </premise>
            <premise model="exploration_automaton" category="conception" type="event">
              <information value="line_ending" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="5" tolerance="0"/>
            </premise>
            <premise model="body" category="perception" type="strength" inhibitor="true">
              <information value="failed" tolerance="INF"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="0" tolerance="0"/>
            </premise>
            <conclusion model="body" category="conception" type="motor">
              <information value="turn_left"/>
            </conclusion>
          </rule>
        </scheme>
        <scheme name="right">
          <rule name="front_turn_action_right">
            <premise model="exploration_automaton" category="conception" type="state">
              <information value="turn" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="0" tolerance="0"/>
            </premise>
            <premise model="orientation" category="conception" type="orientation">
              <information value="right" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="-1" tolerance="INF"/>
            </premise>
            <conclusion model="body" category="conception" type="motor">
              <information value="turn_right"/>
            </conclusion>
          </rule>
          <rule name="turn_action_right">
            <premise model="exploration_automaton" category="conception" type="state">
              <information value="turn" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="-1" tolerance="INF"/>
            </premise>
            <premise model="orientation" category="conception" type="orientation">
              <information value="right" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="-1" tolerance="INF"/>
            </premise>
            <premise model="exploration_automaton" category="conception" type="event">
              <information value="line_ending" tolerance="0"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="5" tolerance="0"/>
            </premise>
            <premise model="body" category="perception" type="strength" inhibitor="true">
              <information value="failed" tolerance="INF"/>
              <credibility value="1" tolerance="INF"/>
              <timespan value="0" tolerance="0"/>
            </premise>
            <conclusion model="body" category="conception" type="motor">
              <information value="turn_right"/>
            </conclusion>
          </rule>
        </scheme>
        <rule name="turn_action_advance">
          <premise model="exploration_automaton" category="conception" type="state">
            <information value="turn" tolerance="0"/>
            <credibility value="1" tolerance="INF"/>
            <timespan value="-1" tolerance="INF"/>
          </premise>
          <premise model="exploration_automaton" category="conception" type="event">
            <information value="line_ending" tolerance="0"/>
            <credibility value="1" tolerance="INF"/>
            <timespan value="2" tolerance="0"/>
          </premise>
          <conclusion model="body" category="conception" type="motor">
            <information value="advance"/>
          </conclusion>
        </rule>
      </scheme>
      <scheme name="events">
        <rule name="line_beginning">
          <premise model="exploration_automaton" category="conception" type="state">
            <information value="turn" tolerance="0"/>
            <credibility value="1" tolerance="INF"/>
            <timespan value="-1" tolerance="INF"/>
          </premise>
          <premise model="exploration_automaton" category="conception" type="event">
            <information value="line_ending" tolerance="0"/>
            <credibility value="1" tolerance="INF"/>
            <timespan value="6" tolerance="0"/>
          </premise>
          <premise model="exploration_automaton" category="conception" type="event" inhibitor="true">
            <information value="last_line_ending" tolerance="0"/>
            <credibility value="1" tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <conclusion model="exploration_automaton" category="conception" type="event">
            <information value="line_beginning"/>
          </conclusion>
        </rule>
        <rule name="line_ending">
          <premise model="exploration_automaton" category="conception" type="state">
            <information value="advance" tolerance="0"/>
            <credibility value="1" tolerance="INF"/>
            <timespan value="-1" tolerance="INF"/>
          </premise>
          <premise model="body" category="perception" type="strength">
            <information value="failed" tolerance="INF"/>
            <credibility value="1" tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <conclusion model="exploration_automaton" category="conception" type="event">
            <information value="line_ending"/>
          </conclusion>
        </rule>
        <rule name="last_line_ending">
          <premise model="exploration_automaton" category="conception" type="state">
            <information value="turn" tolerance="0"/>
            <credibility value="1" tolerance="INF"/>
            <timespan value="-1" tolerance="INF"/>
          </premise>
          <premise model="exploration_automaton" category="conception" type="event">
            <information value="line_ending" tolerance="0"/>
            <credibility value="1" tolerance="INF"/>
            <timespan value="5" tolerance="0"/>
          </premise>
          <premise model="body" category="perception" type="strength">
            <information value="failed" tolerance="INF"/>
            <credibility value="1" tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <conclusion model="exploration_automaton" category="conception" type="event">
            <information value="last_line_ending"/>
          </conclusion>
        </rule>
        <rule name="while_pause">
          <premise model="exploration_automaton" category="conception" type="event">
            <information value="pause" tolerance="0"/>
            <credibility value="1" tolerance="INF"/>
            <timespan value="1" tolerance="0"/>
          </premise>
          <premise model="exploration_automaton" category="conception" type="state" inhibitor="true">
            <information value="wait" tolerance="0"/>
            <credibility value="1" tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <premise model="exploration_automaton" category="conception" type="state" inhibitor="true">
            <information value="stop" tolerance="0"/>
            <credibility value="1" tolerance="INF"/>
            <timespan value="0" tolerance="0"/>
          </premise>
          <conclusion model="exploration_automaton" category="conception" type="event">
            <information value="pause"/>
          </conclusion>
        </rule>
      </scheme>
    </scheme>
  </body>
</program>
