<?xml version="1.0" encoding="UTF-8" ?>
<!--
  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see <http://www.gnu.org/licenses/>
-->
<xsl:stylesheet version="1.0" extension-element-prefixes="str" exclude-result-prefixes="str" xmlns:str="http://exslt.org/strings" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sdk="http://www.nomoseed.org/sdk" xmlns:program="http://www.nomoseed.org/program" >
  <xsl:output method="xml" indent="yes"/>
  <xsl:template match="program:program">
    <xsl:choose>
      <xsl:when test="//sdk:macro[@active='true']">
        <xsl:copy>
          <xsl:attribute name="name">
            <xsl:value-of select="@name"/>
          </xsl:attribute>
          <xsl:apply-templates/>
        </xsl:copy>
      </xsl:when>
      <xsl:otherwise>
        <xsl:copy-of select="."/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template match="program:body">
    <xsl:copy>
      <xsl:apply-templates select="program:models"/>
      <xsl:choose>
        <xsl:when test="program:scheme">
          <xsl:apply-templates select="program:scheme"/>
        </xsl:when>
        <xsl:when test="//sdk:macro[not(@scheme) and @active='true']">
          <xsl:element name="scheme" namespace="http://www.nomoseed.org/program">
            <xsl:apply-templates select="//sdk:macro[not(@scheme) and @active='true']" mode="macro"/>
          </xsl:element>
        </xsl:when>
      </xsl:choose>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="program:scheme">
    <xsl:copy>
      <xsl:apply-templates select="//sdk:macro[not(@scheme) and @active='true']" mode="macro"/>
      <xsl:apply-templates select="program:rule | program:scheme[ not(@name=//sdk:macro/@name)]"/>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="program:scheme[@name]">
    <xsl:copy>
        <xsl:attribute name="name">
          <xsl:value-of select="@name"/>
        </xsl:attribute>
      <xsl:variable name="name" select="@name"/>
      <xsl:apply-templates select="//sdk:macro[@scheme=$name and @active='true']" mode="macro"/>
      <xsl:apply-templates select="program:rule | program:scheme[ not(@name=//sdk:macro/@name)]"/>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="*" mode="macro">
      <xsl:apply-templates mode="macro"/>
  </xsl:template>
  <xsl:template match="sdk:macro" mode="macro">
    <xsl:variable name="csv" select="translate(str:replace(string(./sdk:csv),'&#13;&#10;','&#10;'),' &#34;','')"/>
    <xsl:variable name="lines" select="str:split($csv,'&#10;')"/>
    <xsl:variable name="labels" select="str:split($lines[1],',')"/>
    <xsl:variable name="first">
      <xsl:choose>
        <xsl:when test="@select">
          <xsl:value-of select="substring-before(./sdk:csv/@select,' to ')" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="1" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="last">
      <xsl:choose>
        <xsl:when test="@select">
          <xsl:value-of select="substring-after(./sdk:csv/@select,' to ') + 1" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="count($lines) + 1" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:element name="scheme" namespace="http://www.nomoseed.org/program">
      <xsl:attribute name="name">
        <xsl:value-of select="@name"/>
      </xsl:attribute>
      <xsl:variable name="node" select="./*[position()=last()]/*[local-name()='rule' or local-name()='scheme']"/>         
      <xsl:for-each select="$lines">
        <xsl:if test="position() &gt; $first and position() &lt; $last">
          <xsl:apply-templates select="$node" mode="template">
            <xsl:with-param name="labels" select="$labels"/>
            <xsl:with-param name="values" select="str:split(.,',')"/>
            <xsl:with-param name="number" select="position()"/>
          </xsl:apply-templates>
        </xsl:if>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <xsl:template match="sdk:macro[not(sdk:csv)]" mode="macro">
    <xsl:element name="scheme" namespace="http://www.nomoseed.org/program">
      <xsl:attribute name="name">
        <xsl:value-of select="@name"/>
      </xsl:attribute>      
      <xsl:apply-templates select="./*[position()=last()]/*[local-name()='rule' or local-name()='scheme']" mode="template"/>
    </xsl:element>
  </xsl:template>
  <xsl:template match="*" mode="template">
    <xsl:param name="labels"/>
    <xsl:param name="values"/>
    <xsl:param name="number"/>
    <xsl:element name="{local-name()}" namespace="http://www.nomoseed.org/program">
      <xsl:for-each select="@*">
        <xsl:attribute name="{name()}">
          <xsl:choose>
            <xsl:when test="starts-with(.,'#')">
              <xsl:variable name="label" select="substring-after(.,'#')"/>
              <xsl:for-each select="$labels">
                <xsl:variable name="index" select="position()"/>
                <xsl:if test="$label = .">
                   <xsl:value-of select="$values[$index]"/>
                </xsl:if>
              </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="."/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:attribute>
      </xsl:for-each>
      <xsl:if test="local-name()='rule'">
        <xsl:if test="not(starts-with(@name,'#')) and $number">
          <xsl:attribute name="name">
            <xsl:value-of select="concat(@name, '_', $number - 1)"/>
          </xsl:attribute>
         </xsl:if>
      </xsl:if>
      <xsl:apply-templates select="./*" mode="template">
         <xsl:with-param name="labels" select="$labels"/>
          <xsl:with-param name="values" select="$values"/>
          <xsl:with-param name="number" select="$number"/>
      </xsl:apply-templates >
    </xsl:element>
  </xsl:template>
  <xsl:template match="*">
    <xsl:copy-of select="."/>
  </xsl:template>
</xsl:stylesheet>
