#  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published
#  by the Free Software Foundation, version 2 of the License.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program. If not, see <http://www.gnu.org/licenses/>

args <- commandArgs(TRUE)
library("RSVGTipsDevice")

devSVGTips("points.svg", toolTipMode=0, title="scatter of points by nomoSDK benchmark")
if (substr(args[1],1,2)!="\"/")
	setwd(args[1])
D <- read.csv( file="local.csv", header = TRUE, sep = ",", quote="\"", dec=".", fill = TRUE);
D$label[D$label != 0] = D$label[D$label != 0]/max(D$label[D$label != 0])

if(dim(D)[2]>5)
{
	pairs(D[,5:dim(D)[2]],col=hsv(s=0.7 - as.numeric(D$label == 0)*0.7, v=1, h=D[,4]), pch=D[,1], cex=D[,2], bg="black");
} else
{
	data  = D[,5][D[,3] >= 1]
	data_labels = D[,4][D[,3] >= 1]
	log = D[,5][D[,3] < 0]
	log_labels = D[,4][D[,3] < 0]
	data_levels <- unique(data_labels)
	levels_size <- length(data_levels)
	data_density <- rep(0, levels_size)
	data_var <- rep(0, levels_size)
	data_mean <- rep(0, levels_size)
	data_var_max = 0
	for (i in 1:levels_size)
	{
	#	data_mean[i] = mean(data[data_labels == data_levels[i]])
		data_var[i] = var(data[data_labels == data_levels[i]])
		data_var_max = max(data_var_max, data_var[i])
		data_density[i] = max(density(data[data_labels == data_levels[i]], plot=F)$y); #dnorm(data_mean[i], mean=data_mean[i], sd=data_var[i])
	}
	dmax <- max(data) + data_var_max * 2
	dmin <- min(data) - data_var_max * 2
	plot(density(data), pch=1, xlim=c(dmin,dmax), ylim=c(0,max(data_density)), type="n", main="", xlab="", ylab=args[2])
	log_levels <- unique(log_labels)
	if (length(log)>0)
	{
		for (i in 1:length(log_levels))
			if (length(log[log_labels == log_levels[i]])>20)
				lines(density(log[log_labels == log_levels[i]]),lwd=2, col=hsv(s=0.7, v=1, h=log_levels[i]))
		#	plot(function(x) dnorm(x, mean=mean(log[log_labels == log_levels[i]]), sd=sqrt(var(log[log_labels == log_levels[i]]))), dmax, dmin, add=T)
	}
	if (length(log)>0)
	{
		for (i in 1:length(log_levels))
			rug(log[log_labels== log_levels[i]], side=1, col=hsv(s=0.7, v=1, h=log_levels[i]), ticksize=.03)
	}
#	points(D[,5][D[,1] == 23],rep(0,length(D[,5][D[,1] == 23])), pch='V', cex=2, col='black', bg='black', xlim=c(dmin,dmax))
	for (i in 1:levels_size)
	{	
	#	points(data,rep(0,length(data)), pch=1, col=hsv(s=0.7, v=1, h=data_labels), bg=hsv(s=0.7, v=1, h=data_labels),xlim=c(dmin,dmax))
		rug(data[data_labels== data_levels[i]], side=1, col=hsv(s=0.7, v=1, h=data_levels[i]), ticksize=.015)
		hist(data[data_labels== data_levels[i]], proba=T, col=hsv(s=0.7, v=1, h=data_levels[i]), add=T)
	#	points(hist(data[data_labels== data_levels[i]],plot=F, proba=T), type='l',lwd=2, col=hsv(s=0.7, v=1, h=data_levels[i]), bg=hsv(s=0.7, v=1, h=data_labels))
	#	plot(function(x) dnorm(x, mean=data_mean[i], sd=data_var[i]), dmax, dmin, add=T, col=hsv(s=0.7, v=1, h=data_levels[i]), lty=2)	
	#	hist(data[data_labels== data_levels[i]], proba=T, col=hsv(s=0.7, v=1, h=data_levels[i]));	
	}
	points(D[,5][D[,1] == 23 & D[,3] < 0], max(data_density)/20, pch=25, cex=8, col='black', bg='black', xlim=c(dmin,dmax))
	rules= D[D[,1] == 3 & D[,3] == 0,4:5]
	for (i in 1:length(rules[,1]))
		lines(rep(rules[i,2],2), c(max(data_density)*0.9,0), lty=2, lwd=1, type='l', col=hsv(s=0.7 - as.numeric(rules[i,1] == 0)*0.7, v=1, h=rules[i,1]))
	selection = D[D[,1] == 23 & D[,3] == 0,4:5]
	if (length(selection[,1])!=0)
	{
		lines(rep(selection[,2],2), c(max(data_density)*0.9,0), lty=1, lwd=2, type='l', col=hsv(s=0.7 - as.numeric(rules[i,1] == 0)*0.7, v=1, h=selection[,1]))
	}
}
dev.off()
