--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Printing;

package body Nomo.Internal_Messages.Conclusions.Printing is

   package body CVS is

      procedure Put_Header (File : in out File_Type) is
      begin
         Put (File, ", category");
         Put (File, ", type");
         Put (File, ", conclusion");
         Put (File, ", delay");
      end Put_Header;

      procedure Put_NA (File : in out File_Type) is
         use Nomo.Printing;
      begin
         for i in 1..4 loop
            Put (File, ", " & NA);
         end loop;
      end Put_NA;

      procedure Put (File     : in out File_Type;
                     This     : in Internal_Conclusion;
                     Category : in Type_Category;
                     Id       : in Internal_Type_Index) is
         use Nomo.Printing;
      begin
         Put (File, "," & Type_Category'Image (Category));
         Put (File, "," & Internal_Type_Index'Image (Id));
         Put (File, "," & Positive_Integer'Image (This.Information));
         Put (File, "," & Positive_Time_Interval'Image ( - This.Time_Span));
      end Put;

   end CVS;

   package body XML is

      procedure Put (File     : in out File_Type;
                     This     : in Internal_Conclusion;
                     Category : in Type_Category;
                     Id       : in Internal_Type_Index;
                     Output   : in External_Message;
                     Size     : in Component_Index) is
      begin
         if Category = Command then
            Put (File, "<conclusion category=""" & Type_Category'Image (Category) & """");
            Put (File, " type=""" & Internal_Type_Index'Image (Id) & """");
            Put (File, " value=""" & Positive_Integer'Image (This.Information) & """>");
            Put (File, Output, Size);
            Put (File, "</conclusion>");
         elsif Category = Conception or Category = Prediction then
            Put (File, "<conclusion category=""" & Type_Category'Image (Category) & """");
            Put (File, " type=""" & Internal_Type_Index'Image (Id) & """");
            Put (File, " value=""" & Positive_Integer'Image (This.Information) & """");
            Put (File, " delay=""" & Positive_Time_Interval'Image ( - This.Time_Span) & """ />");
         else
            Put (File, "<conclusion category=""" & Type_Category'Image (Category) & """");
            Put (File, " type=""" & Internal_Type_Index'Image (Id) & """");
            Put (File, " value=""" & Positive_Integer'Image (This.Information) & """ />");
         end if;
      end Put;

   end XML;

   package body DB is

      procedure Put (File    : in out File_Type;
                     T       : in Time;
                     Rule_Id : in Positive;
                     This    : in Internal_Conclusion) is
      begin
         Put (File, Time'Image (T));
         Put (File, "," & Positive'Image (Rule_Id));
         Put (File, "," & Positive_Integer'Image (This.Information));
         if This.Time_Span = Time_Interval'First then
            Put_Line (File, ", INF");
         else
            Put_Line (File, "," & Positive_Time_Interval'Image (- This.Time_Span));
         end if;
      end Put;

   end DB;

end Nomo.Internal_Messages.Conclusions.Printing;
