--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Printing;

package body Nomo.Gen_External_Messages.Printing is

   package body CVS is

      procedure Put_Header (File : in out File_Type) is
      begin
         for I in Component_Index'Range loop
            declare
               Index : constant String := Component_Index'Image (I) (2 .. Component_Index'Image (I)'Last);
            begin
               Put (File, ", output_" & Index);
            end;
         end loop;
      end Put_Header;

      procedure Put_NA (File : in out File_Type) is
         use Nomo.Printing;
      begin
         for I in Component_Index'Range loop
            Put (File, ", " & NA);
         end loop;
      end Put_NA;

      procedure Put (File : in out File_Type;
                     This : in External_Message;
                     Size : in Component_Index) is
         use Nomo.Printing;
         Flag : Boolean := True;
      begin
         for I in Component_Index'Range loop
            if Flag then
               Put (File, "," & Real'Image(This (I)));
               Flag := I /= Size;
            else
               Put (File, ", " & NA);
            end if;
         end loop;
      end Put;

   end CVS;

   package body XML is

      procedure Put (File : in out File_Type;
                     This : in External_Message;
                     Size : in Component_Index) is
      begin
         for I in Component_Index'Range loop
            Put (File, "<output value=""" & Real'Image(This (I)) & """ />");
            exit when I = Size;
         end loop;
      end Put;

   end XML;


   package body DB is

      use Numerics.Times;

      procedure Put (File    : in out File_Type;
                     T       : in Time;
                     Rule_Id : in Positive;
                     This    : in External_Message;
                     Size    : in Component_Index) is
         use Nomo.Printing;
      begin
         for I in Component_Index'First..Size loop
            Put (File, Time'Image (T));
            Put (File, "," & Positive'Image (Rule_Id));
            Put (File, "," & Component_Index'Image (I));
            Put_Line (File, "," & Real'Image(This (I)));
         end loop;
      end Put;

   end DB;

end Nomo.Gen_External_Messages.Printing;
