//  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published
//  by the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program. If not, see <http://www.gnu.org/licenses/>

#ifndef XSLTPROCESSOR_H
#define XSLTPROCESSOR_H

#include <QString>

#include <libxslt/xslt.h>
#include <libxslt/transform.h>

class XSLTProcessor
{
public:

    XSLTProcessor ();

    ~XSLTProcessor ();

    bool importStylesheet (const QByteArray xslPath);

    int setNewParameter (const QString name, const QString value);

    int setNewParameter (const QString name, const int value);

    void setParameter(const int i, const int value);

    void setParameter(const int i, const QString value);

    void resetParameters (void);

    // Attention cette fonction appelle resetParamters à la fin.
    QString transformToFragment (const QString xml);

    xmlChar* transformToFragment (const xmlDocPtr xml);

    xmlDocPtr transform (const xmlDocPtr xml);

    void transformSaveFile (const xmlDocPtr xml, const char *filename);

    xmlDocPtr transformExtensionStr (const xmlDocPtr xml);

    xmlDocPtr transformToFragment (const char * xml);

    bool isEgal(const QString xslPath);

    static QByteArray transform (const QByteArray xslPath, const QString xml, const char ** params);

    static void transform (const char * xslPath, const xmlDocPtr xmlIn, const char* outPath, const char ** params);

private:

    xsltStylesheetPtr xsl;
    const char * params[101];
    QByteArray strings[100];
    int cmp;
    QString path;
};

#endif // XSLTPROCESSOR_H
