//  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published
//  by the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program. If not, see <http://www.gnu.org/licenses/>

#ifndef BENCHMARK_H
#define BENCHMARK_H

#include <QFile>
#include <QProcess>

#include <libxml/parser.h>

#include "module.h"
#include "xsltprocessor.h"

class Benchmark : public Module<Benchmark>
{

    Q_OBJECT

    friend class Module<Benchmark>;

public:

    QString openMap(const QString path);

    QString openPoints(const QString path);

   void close();

   void save();

public slots:

    void populateJavaScriptWindowObject ();

    void startMap();

    void startPoints();

    void pause();

    void reloadData();

    void selectMap();

    void selectMapUnit();

    void reloadMapUnit();

    void selectPoints();

    void selectPointsUnit();

    void reloadPointsUnit();

    void setHueSlab (const QString id, const QString hue);

    void suppAll();

    void suppSphere(const QString on);

    void suppAgent(const QString on);

    void suppSlab(const QString id);

    void setSpheresNbrAgent (const QString spheresNbr);

    void setSpheresNbrAgent (const QString id, const QString spheresNbr);

    const QString getSpheresNbrAgent (const QString id);

    const QString getSpheresNbrAgent ();

    void setSlab (const QString x, const QString y, const QString hue);

    void addSlab (const QString x, const QString y);

    void addSlab ();

    void addSphere();

    void addAgent(const QString direction);

    void moveAgent(const QString on, const QString at);

    void setStepsNumber(const QString);

    void setLogFlag(const QString);

    void setLogPositionFlag(const QString);

    void setFileFlag(const QString);

    void setFinal(const QString);

    void setAnimation(const QString);

    bool getHasLogPartialFile();

    bool getHasLogCompleteFile();

private:

    Benchmark (QMainWindow * mainWindow, QWebView * webView);
    ~Benchmark ();

    QString openMapUnit(QString path);

    QString openPointsUnit(QString path);

    void cleanSeed();

    void openUnit(void);

    void endMap();

    void endPoints();

    void initializeParameters();

    void updateProgressBar(const int progression);

    QString linkUnit(void);

    QString compileUnit(void);

    XSLTProcessor xslXHTML;
    QFile xhtmlFile;
    QUrl xhtmlUrl;
    QString dataPath;
    QString unitPath;
    QString logPath;
    QString hueSlab;
    QString spheresNbrAgent;
    QString xSlab;
    QString ySlab;
    QString unitNameText;
    QString logFlagValueText;
    QString logPositionFlagValueText;
    QString fileFlagValueText;
    QString animationValueText;
    QString dataNameText;
    QString startStateText;
    QString progressionText;
    QString stepsNumberText;
    QString finalValueText;
    QString agentsNbrUnitText;

    bool hasLogPartialFile;
    bool hasLogCompleteFile;
    bool isGoing;

    QProcess* worldsquare;
    QProcess* pointsscatter;

private slots:

    void end();
    void actionPointsscatter ();
    void actionWorldsquare();
    void logFinished (int exitCode, QProcess::ExitStatus exitStatus);
    void repaintMap();
    void refreshMap();
    void refreshPoints();
};

#endif // BENCHMARK_H
