--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package Nomo.Rule_Storages_IO is

   type Byte is range -(2 ** 7) .. +(2 ** 7 - 1);
   for Byte'Size use 8;

   generic
      Storage_Size : Positive;
   package Gen_Bytes is
      pragma Assert (Storage_Size mod 8 = 0);
      type Bytes is array (1 .. Storage_Size / 8) of Byte;
   end Gen_Bytes;

end Nomo.Rule_Storages_IO;
