--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with GNAT.Directory_Operations;

with Nomo.Converter;

package body Nomo.Reader.Finalization is

   function Get_Dir_Name (Directory : in String) return String;
   pragma Inline (Get_Dir_Name);

   function Get_Dir_Name (Directory : in String) return String is
   begin
      if Directory = "" or Directory = "." then
         return GNAT.Directory_Operations.Get_Current_Dir;
      else
         return Directory;
      end if;
   end Get_Dir_Name;

   procedure Save (Directory  : in String;
                   Crush      : in Boolean);
   pragma Inline (Save);

   procedure Save (Directory : in String;
                   Crush     : in Boolean) is
      use File_Properties.Log;
      Dir_Name      : constant GNAT.Directory_Operations.Dir_Name_Str := Get_Dir_Name (Directory);
      Dir           : GNAT.Directory_Operations.Dir_Type;
      Str           : String (1 .. Path_Size_Max);
      Last          : Natural;
      Log_Path      : String (1 .. Path_Size_Max) := (others => 'a');
      Log_Path_Size : Natural := 0;
      Is_Find       : Boolean := False;
   begin
      GNAT.Directory_Operations.Open (Dir, Dir_Name);
      loop
         GNAT.Directory_Operations.Read(Dir, Str, Last);
         if Last > (Log_Final_Prefix'Length + Full_Rule_Extension'Length) and then Str (Last-Full_Rule_Extension'Length + 1 .. Last) = Full_Rule_Extension and then Str (1 .. Log_Final_Prefix'Length) = Log_Final_Prefix then
            if Str (1..Last) > Log_Path (1..Last) then
               Log_Path := Str;
               Log_Path_Size := Last;
               Is_Find := True;
            end if;
         elsif Last = 0 then
            exit when Is_Find;
            raise Missing_File;
         end if;
      end loop;
      Converter.FR_To_Seed (Dir_Name & Log_Path (1 .. Log_Path_Size), Binary_Path (1 .. Binary_Path_Size), Crush);
   end Save;

   procedure Finalize is
      use Ada.Streams.Stream_IO;
   begin
      pragma Assert (Is_Open (Binary_File));
      Close (Binary_File);
   end Finalize;

   procedure Finalize_And_Update (Directory : in String) is
      use Ada.Streams.Stream_IO;
   begin
      pragma Assert (Is_Open (Binary_File));
      Close (Binary_File);
      Save (Directory, True);
   end Finalize_And_Update;

   procedure Finalize_And_Save (Directory : in String) is
      use Ada.Streams.Stream_IO;
   begin
      pragma Assert (Is_Open (Binary_File));
      Close (Binary_File);
      Save (Directory, False);
   end Finalize_And_Save;

end Nomo.Reader.Finalization;
