--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

private package Nomo.Logging_Flags is

   pragma Pure;

   type Log_Flag is (Winner_Partial,
                     Winner_Full,
                     All_Rule_Partial,
                     All_Rule_Full,
                     No_Log
                    );
   for Log_Flag use (Winner_Partial   => 0,
                     Winner_Full      => 1,
                     All_Rule_Partial => 2,
                     All_Rule_Full    => 3,
                     No_Log           => 4);
   pragma Convention (C, Log_Flag);

   type File_Flag is (New_Full_File,
                      New_Partial_File,
                      New_Files,
                      No,
                      Temp
                     );
   for File_Flag use (New_Full_File    => 0,
                      New_Partial_File => 1,
                      New_Files        => 2,
                      No               => 3,
                      Temp             => 4);
   pragma Convention (C, File_Flag);
   pragma Ordered (File_Flag);

end Nomo.Logging_Flags;

