--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Types_Directory.Relations;

package body Nomo.Interpreter.Targets_Rewards.Initialization is

   procedure Initialize (Reward_Type : in Reward_Type_Index;
                         Targets     : out Targets_Reward) is
      use Types_Directory.Relations;
   begin
      Targets.Last := 0;
      for I in 1 .. Index'Last loop
         if Is_Rewardable (Type_Index (I) + Internal_Type_Index'First - 1, Reward_Type) then
            Targets.Last := Targets.Last + 1;
            Targets.Types (Targets.Last) := Type_Index (I) + Internal_Type_Index'First - 1;
         end if;
      end loop;
   end Initialize;

end Nomo.Interpreter.Targets_Rewards.Initialization;
