--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package body Nomo.Interpreter.Storages.Reading is

   function Get_Conclusion_Type (This : in Full_Rule_Storage) return Internal_Type_Index is
   begin
      return This.Conclusion_Type;
   end Get_Conclusion_Type;

   function Get_Id (This : in Full_Rule_Storage) return Positive is
   begin
      return This.Id;
   end Get_Id;

   function Get_Internal_Conclusion (This : in Full_Rule_Storage) return not null access constant Internal_Conclusion is
   begin
      return This.Internal_Conclusion'Unchecked_Access;
   end Get_Internal_Conclusion;

   function Get_Internal_Condition (This : in Full_Rule_Storage) return not null access constant Internal_Premises is
   begin
      return This.Internal_Condition'Unchecked_Access;
   end Get_Internal_Condition;

   function Get_Internal_Condition_Types (This : in Full_Rule_Storage) return not null access constant Internal_Premises_Types is
   begin
      return This.Internal_Condition_Types'Unchecked_Access;
   end Get_Internal_Condition_Types;

   function Get_Internal_Condition_Properties (This : in Full_Rule_Storage) return not null access constant Internal_Premises_Properties is
   begin
     return This.Internal_Condition_Properties'Unchecked_Access;
   end Get_Internal_Condition_Properties;

   function Get_Internal_Premises_Number (This : in Full_Rule_Storage) return Premise_Index is
   begin
      return This.Internal_Premises_Number;
   end Get_Internal_Premises_Number;

   function Get_Fitting_Nbr (This : in Full_Rule_Storage) return Count is
   begin
      return This.Fitting_Nbr;
   end Get_Fitting_Nbr;

   function Get_Relevance (This : in Full_Rule_Storage) return Real_Accurately_0_To_1 is
   begin
      return This.Relevance;
   end Get_Relevance;

   function Get_External_Conclusion (This : in Full_Rule_Storage) return not null access constant External_Message is
   begin
      return This.External_Conclusion'Unchecked_Access;
   end Get_External_Conclusion;

   function Get_External_Condition (This : in Full_Rule_Storage) return not null access constant External_Premise is
   begin
      return This.External_Condition'Unchecked_Access;
   end Get_External_Condition;

   function Get_External_Condition_Type_Index (This : in Full_Rule_Storage) return Input_Type_Index is
   begin
      return This.External_Condition_Type;
   end Get_External_Condition_Type_Index;

end Nomo.Interpreter.Storages.Reading;
