--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Reader.Parameters;
pragma Elaborate_All (Nomo.Reader.Parameters);

with Nomo.Numerics.Times;

with Nomo.Premise_Properties;

with Nomo.Internal_Messages;

with Nomo.Interpreter.External_Messages;

with Nomo.Interpreter.Types_Index.Ranges;

package Nomo.Interpreter.Storages.Plant is

   use Numerics.Times;
   use Internal_Messages;
   use External_Messages;
   use Types_Index.Ranges;
   use Premise_Properties;

   type Premises_Time_Span is array (1 .. Reader.Parameters.Get_Maximum_Of_Premises) of Time_Interval;
   type Premises_Property is array (1 .. Reader.Parameters.Get_Maximum_Of_Premises) of Premise_Property;

   function Internal_Condition_Is_Empty (This : not null access constant Storages.Full_Rule_Storage) return Boolean;
   pragma Inline (Internal_Condition_Is_Empty);

   function Internal_Condition_Is_Full (This : not null access constant Storages.Full_Rule_Storage) return Boolean;
   pragma Inline (Internal_Condition_Is_Full);

   function Has_Input_Premise (This  : not null access constant Storages.Full_Rule_Storage;
                               Index : in Perception_Type_Index) return Boolean;

   procedure Reset (This : not null access Storages.Full_Rule_Storage);
   pragma Inline (Reset);

   procedure Set_Internal_Conclusion (This                : in out Storages.Full_Rule_Storage;
                                      Index               : in Internal_Type_Index;
                                      Internal_Conclusion : in Internal_Message;
                                      Time_Span           : in Negative_Time_Interval;
                                      Operator            : in Positive;
                                      Times_Span          : in Premises_Time_Span;
                                      Properties          : in Premises_Property);

   procedure Set_Internal_Condition (This               : not null access Storages.Full_Rule_Storage;
                                     Index              : in Internal_Type_Index;
                                     Internal_Condition : in Internal_Message;
                                     Operator           : in Positive);

   procedure Set_External_Condition (This               : not null access Storages.Full_Rule_Storage;
                                     Index              : in Input_Type_Index;
                                     External_Condition : in External_Message;
                                     Operator           : in Positive);

  procedure Copy_Condition (This                 : not null access Storages.Full_Rule_Storage;
                             Source               : not null access constant Storages.Full_Rule_Storage;
                             Has_External_Premise : in Boolean);

end Nomo.Interpreter.Storages.Plant;
