--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package Nomo.Interpreter.Rules_Base.Spontaneous is

   type Spontaneous_Rule is abstract new Rule_Base with private;

   procedure Adjust (This : in out Spontaneous_Rule);
   pragma Inline (Adjust);

   procedure Reinforce (This     : in out Spontaneous_Rule;
                        Quantity : in Real_Accurately_0_To_1);
   pragma Inline (Reinforce);

   procedure Update_Relevance (This       : in out Spontaneous_Rule;
                               Expectancy : in Real_Accurately_0_To_1);
   pragma Inline (Update_Relevance);

   procedure Update_Relevance (This : in out Spontaneous_Rule);
   pragma Inline (Update_Relevance);

private

   type Spontaneous_Rule is abstract new Rule_Base with null record;

end Nomo.Interpreter.Rules_Base.Spontaneous;
