--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Beginning.Parameters;
pragma Elaborate_All (Nomo.Interpreter.Beginning.Parameters);

package body Nomo.Interpreter.Rules_Base.Spontaneous is

   Reimbursement_Rate : constant Real_Accurately_0_To_1 := Beginning.Parameters.Get_Reimbursement_Rate;

   procedure Adjust (This : in out Spontaneous_Rule) is
   begin
      Adjust (Rule_Base (This), Reimbursement_Rate);
   end Adjust;

   Reward_Rate : constant Real_Accurately_0_To_1 := Beginning.Parameters.Get_Reward_Rate;

   procedure Reinforce (This     : in out Spontaneous_Rule;
                        Quantity : in Real_Accurately_0_To_1) is
   begin
      This.Relevance := This.Relevance + (1.0 - This.Relevance) * Real_Accurately_0_To_1(Reward_Rate * Quantity);
   end Reinforce;

   Bid_Rate : constant Real_Accurately_0_To_1 := Beginning.Parameters.Get_Bid_Rate;

   Tax_Rate : constant Real_Accurately_0_To_1 := Beginning.Parameters.Get_Tax_Rate;

   procedure Update_Relevance (This       : in out Spontaneous_Rule;
                               Expectancy : in Real_Accurately_0_To_1) is
   begin
      if This.Relevance = 0.0 then
         This.Expectancy_Factor := 0.0;
      else
         declare
            Temp : constant Real_Accurately_0_To_1 := 1.0 - This.Relevance;
         begin
            This.Expectancy_Factor := Expectancy * Temp;
            This.Relevance := This.Relevance - Real_Accurately_0_To_1 (Tax_Rate + Bid_Rate * Expectancy) * Real_Accurately_0_To_1 (Temp * This.Relevance);
         end;
      end if;
   end Update_Relevance;

   procedure Update_Relevance (This : in out Spontaneous_Rule) is
   begin
      This.Relevance := This.Relevance - Tax_Rate * Real_Accurately_0_To_1((1.0 - This.Relevance) * This.Relevance);
   end Update_Relevance;

end Nomo.Interpreter.Rules_Base.Spontaneous;
