--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Storages.Reading;

package body Nomo.Interpreter.Rules_Base.Initialization is

   procedure Initialize (This   : out Rule_Base;
                         Rule_Storage : in Storages.Full_Rule_Storage) is
   begin
      This.Id := Storages.Reading.Get_Id (Rule_Storage);
      This.Relevance := Storages.Reading.Get_Relevance (Rule_Storage);
      This.Is_Updatable := This.Relevance < 1.0;
   end Initialize;

end Nomo.Interpreter.Rules_Base.Initialization;
