--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Reals;

package Nomo.Interpreter.Rules_Base.Delayed is

   use Nomo.Numerics.Reals;

   type Delayed_Rule is abstract new Rule_Base with private;

   procedure Add_Score (This          : in out Delayed_Rule;
                        Score         : in Positive_Real;
                        Is_Noteworthy : out Boolean);
   --  Renvoie vrai lorsque le score de l'valuation ponctuelle
   --  est surprieur aux prcdentes.

   procedure Adjust (This           : in out Delayed_Rule;
                     Is_Maximizable : out Boolean);
   pragma Inline (Adjust);

   procedure Reset (This : in out Delayed_Rule);
   pragma Inline (Reset);

   procedure Update_Relevance (This : in out Delayed_Rule);
   pragma Inline (Update_Relevance);

private

   type Delayed_Rule is abstract new Rule_Base with record
      Score_Max  : Positive_Real := 0.0;
      Scores_Sum : Positive_Real := 0.0;
   end record;

end Nomo.Interpreter.Rules_Base.Delayed;
