--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Event_Memory.Internal.Intuition;

with Nomo.Interpreter.Targets_Rewards.Reinforcement;

package body Nomo.Interpreter.Rewards_Clusters is

   procedure Assume (This : in out Rewards_Cluster;
                     T    : in Positive_Time) is
      use Targets_Rewards.Reinforcement;
      Selected_Rule : Rewarding_Rule_Ptr renames Cluster_Base (This).Get_Selected_Rule;
   begin
      Event_Memory.Internal.Intuition.Put_Event (This.Reward_Type,
                                                 Selected_Rule.all.Get_Conclusion.all,
                                                 T);
      Reinforce (This.Targets,
                 T,
                 Selected_Rule.all.Get_First_Landmark,
                 Selected_Rule.all.Get_Second_Landmark,
                 Selected_Rule.all.Get_Reward_Quantity);
   end Assume;

   function Has_Selection (This : in Rewards_Cluster) return Boolean is
   begin
      return Cluster_Base (This).Has_Selection;
   end Has_Selection;

   procedure Interpret (This : in out Rewards_Cluster) is
   begin
      Cluster_Base (This).Interpret;
   end Interpret;

end Nomo.Interpreter.Rewards_Clusters;
