--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Conditions_Base.Initialization;

package body Nomo.Interpreter.Reward_Conditions.Initialization is

   procedure Initialize (This                       : in out Reward_Condition;
                         Premises                   : in Internal_Premises;
                         Premises_Types             : in Internal_Premises_Types;
                         Properties                 : in Internal_Premises_Properties;
                         Premises_Number            : in Premise_Index;
                         Fitting_Nbr                : in Count;
                         Matchmaker_Ptr             : not null access Internal_Events_Index.Matchmakers.Matchmaker;
                         Excitatory_Specificity_Log : out Real_Accurately;
                         Inhibitory_Specificity_Log : out Real_Accurately) is
      use Conditions_Base.Initialization;
   begin
      Initialize (Condition_Base (This),
                  Premises,
                  Premises_Types,
                  Properties,
                  Premises_Number,
                  Fitting_Nbr,
                  Matchmaker_Ptr,
                  Excitatory_Specificity_Log,
                  Inhibitory_Specificity_Log);
      This.First_Landmark := Get_First_Landmark_Index (Condition_Base (This));
      if This.First_Landmark /= 0 then
         This.Second_Landmark := Get_Second_Landmark_Index (Condition_Base (This));
      else
         This.Second_Landmark := 0;
      end if;
   end Initialize;

end Nomo.Interpreter.Reward_Conditions.Initialization;
