--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Premise_Properties;

package Nomo.Interpreter.Premises_Index.Focus.Directories is

   use Premise_Properties;

   type Premises_Focus_Index is new Premise_Index;
   type Types_Focus is limited record
      First : Premises_Focus_Index range 1 .. Premises_Focus_Index'Last := 1;
      Last  : Premises_Focus_Index := 0;
   end record;

   First_Excitator : constant Premise_Index := 1;

   type Premises_Directory is tagged limited private;

   function Get_Types_Range (This     : in Premises_Directory;
                             Property : in Premise_Property ) return not null access constant Types_Focus;

   function Get_Premises_Last (This : in Premises_Directory) return Premise_Index;

   function Get_Internal_Premises_Range (This : in Premises_Directory;
                                         I    : in Premises_Focus_Index) return not null access constant Premises_Focus;
   pragma Precondition (I /= 0);

   function Get_Excitator_Last (This : in Premises_Directory) return Premise_Index;

private

   type Types_Focus_Register is array (Premise_Property'Range) of aliased Types_Focus;
   type Premises_Focus_Register is array (Premises_Focus_Index range 1 .. Premises_Focus_Index'Last) of aliased Premises_Focus;

   type Premises_Directory is tagged limited record
      Types_Ranges    : Types_Focus_Register;
      Premises_Ranges : Premises_Focus_Register;
      Excitator_Last  : Premise_Index := 0;
      Premises_Last   : Premise_Index := 0;
   end record;

end Nomo.Interpreter.Premises_Index.Focus.Directories;
