--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Fitting;

with Nomo.Numerics.Reals;

with Nomo.Numerics.Informations;

with Nomo.Numerics.Times;

with Nomo.Premise_Properties;

package Nomo.Interpreter.Premises_Index.Arrays.Plant is

   use Numerics.Fitting;
   use Premises_Index_Instance;

   procedure Adjust_Trend (This        : in out Internal_Premises;
                           Last        : in Premise_Index;
                           Fitting_Nbr : in Count);
   pragma Inline (Adjust_Trend);

   use Numerics.Informations;
   use Numerics.Times;
   use Numerics.Reals;

   procedure Set (This                  : in out Internal_Premises;
                  I                     : in Premise_Index;
                  Information           : in Positive_Integer;
                  Information_Tolerance : in Boolean;
                  Time_Span             : in Time_Interval;
                  Time_Span_Tolerance   : in Strictly_Positive_Real;
                  Credibility           : in Real_0_To_1;
                  Credibility_Tolerance : in Strictly_Positive_Real);
   pragma Precondition (I > 0);
   pragma Inline (Set);

   type Premises_Times_Span is array (1 .. Premise_Index'Last) of Time_Interval;

   procedure Set_Times_Span (This       : in out Internal_Premises;
                             Last       : in Premise_Index;
                             Times_Span : in Premises_Times_Span);

   use Premise_Properties;

   type Premises_Property is array (1 .. Premise_Index'Last) of Premise_Property;

   procedure Sort (This             : in out Internal_Premises;
                   Last             : in Premise_Index;
                   Types            : in out Internal_Premises_Types;
                   Index_Properties : out Internal_Premises_Properties;
                   Properties       : in out Premises_Property);

end Nomo.Interpreter.Premises_Index.Arrays.Plant;
