--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

private with Nomo.Interpreter.Types_Index.Ranges;

private with Nomo.Interpreter.Storages;

package Nomo.Interpreter.Plant.Rule_Buffer is

private

   use Types_Index.Ranges;
   use Types_Index.Types_Index_Instance;

   type Buffer_Index is new Positive range 1 .. Integer (Scope_Type_Index'Last - Scope_Type_Index'First);

   Buffers       : array (Buffer_Index'Range) of aliased Storages.Full_Rule_Storage;
   Buffer_Last   : Buffer_Index;
   Reading_Index : Buffer_Index;
   Buffer_Type   : Types_Index.Types_Index_Instance.Type_Index := 0;

end Nomo.Interpreter.Plant.Rule_Buffer;
