--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Times;

package Nomo.Interpreter.Plant.Errors_Manager is

   use Numerics.Times;

   type Error_Label is (AFFECTATION_EXPIRED_FOR_REFERENCE_TIME,
                        AFFECTATION_EXPIRED_FOR_SHIFTING_TIME,
                        AFFECTATION_EXPIRED_OPERATOR_FOR_TARGET,
                        ALREADY_AFFECTED_CHUNK,
                        ALREADY_CREATED_PERCEPTION,
                        ALREADY_DESIGNED_REFERENCE_TIME,
                        ALREADY_DESIGNED_TARGET,
                        BAD_REFERENCE_TIME,
                        EXPIRED_EXTERNAL_CHUNCK,
                        EXPIRED_INTERNAL_CHUNCK,
                        EXPIRED_INTERNAL_TARGET,
                        FAIL_CHUNCK_INACTIVE,
                        FAIL_LANDMARK_ID,
                        FAIL_LANDMARK_TYPE,
                        FAIL_LINKED_PERCEPTION,
                        FAIL_PERCEPTION_OF_COMMAND_CONCLUSION,
                        FAIL_PREDICTION_ID_IN_CHECKING_RULE,
                        FAIL_PREDICTIVE_TYPE_IN_CHECKING_RULE,
                        FAIL_SEARCH_EVENT,
                        FAIL_TARGETED_AFFECTATION,
                        FORBIDDEN_REFLECTION_RETURN_IN_CONCLUSION,
                        ILLEGAL_CREATION_OPERATOR_IN_EXTERNAL_CHUNK,
                        ILLEGAL_CREATION_OPERATOR_IN_INTERNAL_CHUNK,
                        ILLEGAL_LANDMARK_TYPE,
                        ILLEGAL_OPERATOR_IN_AFFECTATION,
                        ILLEGAL_OPERATOR_IN_CONCLUSION,
                        ILLEGAL_OPERATOR_IN_CONDITION,
                        ILLEGAL_REFERENCE_FOR_CREATION,
                        ILLEGAL_REFERENCE_FOR_INPUT_CONDITION,
                        ILLEGAL_REFERENCE_FOR_INTERNAL_CONCLUSION,
                        ILLEGAL_REFERENCE_FOR_INTERNAL_CONDITION,
                        ILLEGAL_REFERENCE_FOR_PERCEPTION_CONCLUSION,
                        ILLEGAL_START_IN_AFFECTATION,
                        ILLEGAL_START_IN_CONCLUSION,
                        ILLEGAL_START_IN_EXCITATORY_PREMISE,
                        ILLEGAL_START_IN_INHIBITORY_PREMISE,
                        ILLEGAL_START_IN_STANDBY,
                        ILLEGAL_TARGET_IN_EXTERNAL_CHUNK,
                        INPUT_PREMISE_IN_INHIBITORY_PREMISE,
                        INPUT_PREMISE_MISSING,
                        MISSING_LANDMARK_RULE,
                        MISSING_PREDICTIVE_RULE,
                        MISSING_TARGET_FOR_AFFECTATION_OPERATOR,
                        NO_UNIQUE_COMMAND_CONCLUSION,
                        NO_UNIQUE_PERCEPTION_CONCLUSION,
                        NO_UNIQUE_PREDICTION_CONCLUSION,
                        OVER_AFFECTATION_OPERATORS_FOR_TARGET,
                        OVER_INPUT_PREMISE,
                        OVER_INTERNAL_PREMISES_NUMBER,
                        OVER_RULES,
                        OVER_TIME_SPAN_FOR_INTERNAL_CONDITION,
                        SAME_TIME_CONDITION_CONCLUSION
                       );

   procedure Error (Label : in Error_Label);

   procedure Update_Sending_Time (T : in Positive_Time);
   pragma Inline (Update_Sending_Time);

end Nomo.Interpreter.Plant.Errors_Manager;
