--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Plant.Error;

with Nomo.Internal_Messages.Plant;

with Nomo.Interpreter.Event_Memory.Internal.Intuition;

with Nomo.Interpreter.Types_Index.Ranges;

package body Nomo.Interpreter.Plant.Errors_Manager is

   use Internal_Messages;

   Message : Internal_Message;
   Sending_Time : Positive_Time;

   procedure Error (Label : in Error_Label) is
      use Internal_Messages.Plant;
      use Types_Index.Ranges;
   begin
      Set_Information (Message, Error_Label'Pos (Label));
      Event_Memory.Internal.Intuition.Put_Event (Anomaly_Type_Index'First,
                                                 Message,
                                                 Sending_Time);
      raise Plant.Error.PARSER_FAIL;
   end Error;

   procedure Update_Sending_Time (T : in Positive_Time) is
   begin
      Sending_Time := T;
   end Update_Sending_Time;

end Nomo.Interpreter.Plant.Errors_Manager;
