--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Informations;

with Nomo.Interpreter.Types_Index.Ranges;

with Nomo.Interpreter.Storages;

limited with Nomo.Interpreter.Internal_Events_Index.Matchmakers;

package Nomo.Interpreter.Perception_Rules.Initialization is

   use Storages;
   use Types_Index.Ranges;
   use Numerics.Informations;

   procedure Initialize (This                       : out Perception_Rule;
                         Rule_Storage               : in Full_Rule_Storage;
                         Matchmaker_Ptr             : not null access Internal_Events_Index.Matchmakers.Matchmaker;
                         Excitatory_Specificity_Log : out Real_Accurately;
                         Inhibitory_Specificity_Log : out Real_Accurately;
                         Input_Type                 : in Input_Type_Index);

   function Is_Equal (This        : in Perception_Rule;
                      Information : in Positive_Integer) return Boolean;

end Nomo.Interpreter.Perception_Rules.Initialization;
