--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Informations;

with Nomo.Interpreter.External_Messages;

package Nomo.Interpreter.Perception_Rules.Feedback is

   use Numerics.Informations;

   function Is_Optimizable (This       : not null access constant Perception_Rule;
                            Perception : in Positive_Integer) return Boolean;

   use External_Messages;

   procedure Get_Feedback (This        : not null access constant Perception_Rule;
                           Information : not null access External_Message);
   pragma Inline (Get_Feedback);

   procedure Get_Last_Feedback (This        : not null access constant Perception_Rule;
                                Information : not null access External_Message;
                                Perception  : in Positive_Integer);
   pragma Inline (Get_Last_Feedback);

end Nomo.Interpreter.Perception_Rules.Feedback;
