--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Perception_Conditions.Feedback;

package body Nomo.Interpreter.Perception_Rules.Feedback is

   function Is_Optimizable (This       : not null access constant Perception_Rule;
                            Perception : in Positive_Integer) return Boolean is
   begin
      return This.all.Condition.Is_Optimizable and then not(This.all.Is_Forget) and then This.all.Conclusion.Get_Information = Perception;
   end Is_Optimizable;

   procedure Get_Feedback (This        : not null access constant Perception_Rule;
                           Information : not null access External_Message) is
      use Perception_Conditions.Feedback;
   begin
      Get_Feedback (This.all.Condition, Information);
   end Get_Feedback;

   procedure Get_Last_Feedback (This        : not null access constant Perception_Rule;
                                Information : not null access External_Message;
                                Perception  : in Positive_Integer) is
      use Perception_Conditions.Feedback;
   begin
      if This.all.Conclusion.Get_Information = Perception then
         Get_Last_Feedback (This.all.Condition, Information);
      end if;
   end Get_Last_Feedback;

end Nomo.Interpreter.Perception_Rules.Feedback;
